<?php

class DUtil
{

	public static function object_sort(&$array_data, $column, $direction, $type) {
                // get a list of columns
                $columns = array();

                foreach ($array_data as $key => $row) {
                   $columns[$key]  = $row->$column;

                }

                array_multisort($columns, $direction, $type, $array_data);
	}

	public static function grab_input($origin = "",$name = "",$type = "") {
		$temp = null;

		$origin = strtoupper($origin);

		if($name == "" || $origin == "") {
			die("input error");
		}

		switch($origin) {
			case "REQUEST":
			case "ANY":
			$temp = $_REQUEST;
			break;
			case "GET":
			$temp = $_GET;
			break;
			case "POST":
			$temp = $_POST;
			break;
			case "COOKIE":
			$temp = $_COOKIE;
			break;
			case "FILE":
			$temp = $_FILES;
			break;
			case "SERVER":
			$temp = $_SERVER;
			break;
			default:
			die("input extract error.");
			break;
		}


		if(array_key_exists($name,$temp)) {
			$temp =  $temp[$name];
		}
		else {
			$temp = null;
		}

		switch($type) {
			case "int":
				return (int) $temp;
				break;
			case "float":
				return (float) $temp;
				break;
			case "string":
				return trim((string) $temp);
				break;
			case "array":
				return (is_array($temp) ?  $temp : null);
				break;
			case "object":
				return (is_object($temp) ?  $temp : null);
				break;
			default:
				return trim((string) $temp); //default string
				break;

		}

	}

	public static function genOptions($options, $selValue)
	{
		$o = '';
		if ( $options )
		{
			foreach ( $options as $key => $value )
			{
				$o .= '<option value="' . $key .'"';
				if ( $key == $selValue )
					$o .= ' selected';
				$o .= ">$value</option>\n";
			}
		}
		return $o;
	}

	public static function getGoodVal($val)
	{
		if ( $val != null && strpos($val, '<') !== false )
		{
			return null;
		}
		else
			return $val;
	}

	public static function getGoodVal1(&$val)
	{
		if ( $val != null && strpos($val, '<') !== false )
		{
			$val = null;
			return null;
		}
		else
			return $val;
	}

	public static function getLastId($id)
	{
		if ( $id == null )
			return null;

		$pos = strrpos($id, '`');
		if ( $pos === false )
			return $id;
		else
			return substr($id, $pos+1);
	}

	public static function trimLastId(&$id)
	{
		$pos = strrpos($id, '`');
		if ( $pos !== false )
			$id = substr($id, 0, $pos);
		else
			$id = null;
	}

	public static function switchLastId(&$curId, $newId)
	{
		$pos = strrpos($curId, '`');
		if ( $pos !== false )
			$curId = substr($curId, 0, $pos+1) . $newId;
		else
			$curId = $newId;
	}

	public static function &locateData0(&$holder, $dataloc, $ref=null)
	{
		$data = &$holder;

		if ( $dataloc != null )
		{
			$datalocs = explode(':', $dataloc);

			foreach ( $datalocs as $loc )
			{
				$data = &$data[$loc];
			}
			if ( $ref != null )
				$data = &$data[$ref];
		}
		return $data;
	}

	public static function &locateData(&$holder, $dataloc, $ref = null)
    {
        $data = &$holder;
        if ($ref != null) {
            $refs = explode('`', $ref);
        }

        if ($dataloc != null) {
            $datalocs = explode(':', $dataloc);
            foreach ($datalocs as $loc) {
                $r = strpos($loc, '!$');

                if ($r > 0) {
                    $a = substr($loc, $r + 2);
                    $loc = substr($loc, 0, $r);
                    $data = &$data[$loc][$refs[$a]];
                }
                else {
                    $data = &$data[$loc];
                }
            }
        }
        return $data;
    }

    public static function getSubTid($subTbls, $data)
	{
		$key = $subTbls[0];
		if ( !isset($data[$key]) )
			return $subTbls[1];

		$newkey = $data[$key]->GetVal();
		if ( ($newkey == '0') || !isset($subTbls[$newkey]) ) {
			return $subTbls[1];
		}
		else
			return $subTbls[$newkey];
	}

	public static function splitMultiple($val)
	{
		return preg_split("/, /", $val, -1, PREG_SPLIT_NO_EMPTY);
	}

	public static function array_string_keys($input)
	{
		$output = array();
		if ($input != null && is_array($input)) {
			foreach($input as $k => $v) {
				$output[] = (string)$k;
			}
		}
		return $output;

	}

	public static function getDataVal(&$holderArray, $key)
	{
		if ($holderArray == null
				|| ! is_array($holderArray)
				|| empty($holderArray[$key])
				|| ! is_a($holderArray[$key], 'CVal')) {
			return null;
		}
		else {
			return $holderArray[$key]->GetVal();
		}
	}

	public static function dbg_out($tag, &$obj, $visible=true)
	{
		if ($visible)
			echo "<pre> $tag \n" . print_r($obj, true) . "\n</pre>";
		else
			echo "<!-- $tag --\n" . print_r($obj, true) . "-->\n";
	}

	public static function dbg_tag($tag, $visible=true)
	{
		if ($visible)
			echo "<pre>$tag \n</pre>";
		else
			echo "<!-- $tag -->\n";
	}


}
