<?php

class DAttr extends DAttrBase
{
    // 0: no restriction; 1: LSWS ENTERPRISE; 2: LSWS 2CPU +;
    // 3: LSLB 2CPU +; 4: X-CPU
	public $_version = 0;
	public $_feature = 0; // feature bit

	public function dup($key, $label, $helpkey)
	{
		$d = parent::dup($key, $label, $helpkey);
		$d->_version = $this->_version;
		$d->_feature = $this->_feature;
		return $d;
	}

	public function bypassSavePost()
	{
		return ($this->_FDE[2] == 'N' || $this->blockedReason());
	}

	public function blockedReason()
	{
		if ($this->_feature == 0 && $this->_version == 0) {
			return '';	// no restriction
        }
        // feature either cache or litemage
		if ($this->_feature != 0) {
			$features = $_SERVER['LS_FEATURES'];
			if ( ($this->_feature & $features) != 0) {
                return ''; // feature enabled
            }
            if ($this->_feature == 1) {
                return 'This feature requires LSCache module enabled in your license';
            }
            if ($this->_feature == 10) {
                return 'This feature requires LiteMage module enabled in your license';
            }
            return 'This feature is not supported by your license';  // fail safe, should not happen
		}

		if ($this->_version == 1) {
			// LSWS ENTERPRISE;
			$edition = strtoupper($_SERVER['LSWS_EDITION']);
			if ( strpos($edition, "ENTERPRISE" ) !== false ) {
                return ''; // enabled
            } else {
                return $_SERVER['LSWS_EDITION'] . 'This feature is available in Enterprise Edition';
            }
		}

        $proc = $_SERVER['LSWS_CHILDREN']{0};
        if ( !$proc) {
            $proc = 1;
        }
		if ($this->_version == 2) {
			// LSWS 2CPU +
            if ($proc < 2) {
                return 'This feature is available for Multiple-Worker license';
            } else {
                return '';
            }
		}

		if ($this->_version == 4) {
            // XCPU, unlimited is 9:n (n is actual used)
             if ($proc != '9') {
                return 'This feature is available for Web Host Elite license';
             } else {
                 return '';
             }

		}

        return 'feature not supported'; // fail safe exit
	}


}
