#!/bin/sh

OS=`uname -s`
HW=`uname -i`


CHROOT=$1
EXECUTABLE=$2
if [ "x$CHROOT" = "x" ]; then
        cat <<EOF
Usage: chrootEnv.sh <chroot path> [path_to_binary]

EOF
        exit 1
fi
CUR_USER=`id`
CUR_USER=`expr "$CUR_USER" : 'uid=.*(\(.*\)) gid=.*'`

if [ $CUR_USER != "root" ]; then
        echo "[ERROR] You must be root user to setup chroot environment!"
fi

if [ `expr "$CHROOT" : '\/'` -eq 0 ]; then
        echo "[ERROR] Chroot path must be absolute path!"
        exit 1
fi

if [ $CHROOT = "/" ]; then
        echo "It is not necessory to setup the environment when chroot to '/'."
        exit 0
fi

if [ -f $CHROOT ]; then
        echo "[ERROR] chroot directory does not exist!"
        exit 1
fi

copy_library()
{
        ldd $EXECUTABLE > /tmp/dynlibs
        while read dynlib 
        do
                if [ "x$OS" != "xSunOS" ]; then
                        libname=`expr "$dynlib" : '\(.*\) => .* .*'`
                        libpath=`expr "$dynlib" : '.* => \(.*\) .*'`
                else
                        libname=`expr "$dynlib" : '[ ]*\(.*\) =>.*'`
                        libpath=`expr "$dynlib" : '.* =>[        ]*\(.*\)'`
                fi
                if [ "x$libpath" != "x" ]; then
                        if [ "$libpath" = "/usr/lib/$libname" ]; then
                                #if [ ! -f "$CHROOT/usr/lib/$libname" ] && [ ! -f "$CHROOT/$libname" ]; then
                                        cp $libpath $CHROOT/usr/lib
                                #fi
                        elif [ "$libpath" = "/usr/lib64/$libname" ]; then
                                #if [ ! -f "$CHROOT/usr/lib64/$libname" ] && [ ! -f "$CHROOT/$libname" ]; then
                                        cp $libpath $CHROOT/usr/lib64
                                #fi
                        elif [ "$libpath" = "/lib64/$libname" ]; then
                                #if [ ! -f "$CHROOT/lib64/$libname" ] && [ ! -f "$CHROOT/$libname" ]; then
                                        cp $libpath $CHROOT/lib64
                                #fi
                        else
                                #if [ ! -f "$CHROOT/lib/$libname" ] && [ ! -f "$CHROOT/$libname" ]; then
                                        cp $libpath $CHROOT/lib
                                #fi

                        fi
                fi
        done < /tmp/dynlibs
        rm /tmp/dynlibs
}

copy_perl()
{
    cp /usr/bin/perl $CHROOT/usr/bin
    EXECUTABLE=/usr/bin/perl
    copy_library
    
        if [ "x$OS" = "xFreeBSD" ]; then
        mkdir $CHROOT/usr/libdata
        cp -R /usr/libdata/perl  $CHROOT/usr/libdata

        elif [ "x$OS" = "xSunOS" ]; then
        cp -R /usr/perl5      $CHROOT/usr

	elif [ "x$HW" = "xx86_64" ]; then
	cp -R /usr/lib64/perl5 $CHROOT/usr/lib64

    else
        cp -R /usr/lib/perl5  $CHROOT/usr/lib
        fi
    
}


update_existing()
{
    cd $CHROOT
    for f in `find lib lib64 usr/lib usr/lib64 bin usr/bin -type f`; do rsync -av -L /$f ./$f; done
    rsync -av /etc/pki ./etc/

    #NSS required file, otherwise curl breaks
    FILES="/lib64/libfreeblpriv3.chk 
/lib64/libfreeblpriv3.so 
/lib64/libfreebl3.so 
/lib64/libfreebl3.chk 
/usr/lib64/libnsssysinit.so 
/usr/lib64/libnsspem.so 
/usr/lib64/libnssdbm3.so 
/usr/lib64/libnssdbm3.chk 
/usr/lib64/libsoftokn3.so 
/usr/lib64/libsoftokn3.chk"    
    for f in $FILES ; do rsync -av -L /$f ./$f; done
    ln -sf ../../lib64/libfreeblpriv3.so $CHROOT/usr/lib64/libfreeblpriv3.so
}


if [ "x$EXECUTABLE" = 'x' ]; then
        for req_dir in 'bin' 'lib' 'usr' 'usr/bin' 'usr/lib' 'dev' 'tmp' 'etc'
            do
            if [ ! -d "$CHROOT/$req_dir" ]; then
                    mkdir $CHROOT/$req_dir
                    chmod 755 $CHROOT/$req_dir
            fi
        done 
        chmod 1777 $CHROOT/tmp

	if [ "x$HW" = "xx86_64" ]; then
	    for req_dir in 'lib64' 'usr/lib64'
		do
	            if [ ! -d "$CHROOT/$req_dir" ]; then
       		             mkdir $CHROOT/$req_dir
               		     chmod 755 $CHROOT/$req_dir
            	    fi
        	done
	fi

        if [ "x$OS" = "xFreeBSD" ]; then
                mknod $CHROOT/dev/null c 2 2
                mknod $CHROOT/dev/random c 2 3
                mknod $CHROOT/dev/urandom c 2 4
                mknod $CHROOT/dev/zero c 2 12
                mkdir $CHROOT/usr/libexec
                cp /usr/libexec/ld* $CHROOT/usr/libexec
        mkdir $CHROOT/usr/share
        cp -R /usr/share/locale   $CHROOT/usr/share

        elif [ "x$OS" = "xSunOS" ]; then
                mknod $CHROOT/dev/null c 13 2
                mknod $CHROOT/dev/random c 82 0
                mknod $CHROOT/dev/urandom c 82 1
#from solaris 10
#               mknod $CHROOT/dev/random c 149 0
#               mknod $CHROOT/dev/urandom c 149 1
#               mknod $CHROOT/dev/poll c 138 0
                mknod $CHROOT/dev/zero c 13 12
                cp /usr/lib/ld.so.1 /usr/lib/libdl.so.1 /usr/lib/libc.so.1 $CHROOT/usr/lib
        cp -R /usr/lib/locale $CHROOT/usr/lib
        else
                mknod $CHROOT/dev/null c 1 3
                mknod $CHROOT/dev/random c 1 8
                mknod $CHROOT/dev/urandom c 1 9
                mknod $CHROOT/dev/zero c 1 5

            if [ "x$OS" = "xLinux" ]; then
            cp /lib/ld-linux.so.* $CHROOT/lib
        fi
        cp /lib/libnss_dns.so.* $CHROOT/lib
        cp /lib/libnss_files.so.* $CHROOT/lib
        cp /lib/libnss_nisplus.so.* $CHROOT/lib
        cp /lib/libtermcap.so.* $CHROOT/lib
        cp -R /usr/lib/locale   $CHROOT/usr/lib
        cp /etc/netconfig       $CHROOT/etc        
		if [ "x$HW" = "xx86_64" ]; then
		        cp /lib64/libnss_dns.so.* $CHROOT/lib64
		        cp /lib64/libnss_files.so.* $CHROOT/lib64
		        cp /lib64/libnss_nisplus.so.* $CHROOT/lib64
		        cp /lib64/libtermcap.so.* $CHROOT/lib64
			cp /lib64/ld-* $CHROOT/lib64
		fi
        
        fi
        chmod 666 $CHROOT/dev/*
        cp /etc/localtime $CHROOT/etc/
        cp /etc/resolv.conf $CHROOT/etc/
        cp /etc/hosts $CHROOT/etc/
        #chown root $CHROOT
        #chmod 700  $CHROOT
        touch $CHROOT/etc/passwd $CHROOT/etc/group $CHROOT/etc/shadow
        chmod 400 $CHROOT/etc/shadow

        for req_bin in 'dirname' 'ldd' 'cat' 'echo' 'date' 'sh'
          do
          if [ ! -f "$CHROOT/bin/$req_bin" ]; then
                  if [ -f "/bin/$req_bin" ]; then
                          cp /bin/$req_bin $CHROOT/bin
                      chmod 755 $CHROOT/bin/$req_bin
                          EXECUTABLE=/bin/$req_bin
                  elif [ -f "/usr/bin/$req_bin" ]; then
                          cp /usr/bin/$req_bin $CHROOT/usr/bin
                          chmod 755 $CHROOT/usr/bin/$req_bin
                          EXECUTABLE=/usr/bin/$req_bin
                  elif [ -f "/sbin/$req_bin" ]; then
                          cp /sbin/$req_bin $CHROOT/bin
                          chmod 755 $CHROOT/bin/$req_bin
                          EXECUTABLE=/sbin/$req_bin
                  elif [ -f "/usr/sbin/$req_bin" ]; then
                          cp /usr/sbin/$req_bin $CHROOT/usr/bin
                          chmod 755 $CHROOT/usr/bin/$req_bin
                          EXECUTABLE=/usr/sbin/$req_bin
                  fi
                  copy_library
          fi
        done

elif [ "x$EXECUTABLE" = 'xperl' ]; then
    copy_perl
elif [ "x$EXECUTABLE" = 'xupdate_chroot' ]; then
    update_existing
else
        copy_library
fi

