<?php
include '../includes/cms/session.php';
include '../includes/Conn.php';
?><!doctype html>
<html lang="he" dir="rtl">
<head>
<meta charset="utf-8">
<title>ניהול מותגים</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/cropperjs@1.6.2/dist/cropper.min.css">
<style>
  .brand-card{border:1px solid #eee;border-radius:12px;padding:12px;margin-bottom:12px}
  .brand-card img{max-height:60px;border-radius:8px}
</style>
</head>
<body class="container py-3">
  <h1 class="h4 mb-3">מותגים</h1>
  <form id="brand-form" class="row g-2 align-items-end mb-4">
    <div class="col-md-4">
      <label class="form-label">שם מותג</label>
      <input type="text" name="name" class="form-control" required>
    </div>
    <div class="col-md-4">
      <label class="form-label">לוגו מותג (אופציונלי)</label>
      <input type="file" name="file" accept="image/*" class="form-control">
    </div>
    <div class="col-md-4">
      <button class="btn btn-primary">הוסף מותג</button>
    </div>
  </form>
  <div id="brand-list"></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
async function loadBrands(){
  const res = await fetch('/api/brands.php?action=list');
  const j = await res.json();
  if(!j.ok) return;
  const d = document.getElementById('brand-list');
  d.innerHTML = j.rows.map(r=>`
    <div class="brand-card d-flex justify-content-between align-items-center">
      <div class="d-flex gap-3 align-items-center">
        ${r.img_226 ? `<img src="${r.img_226}" alt="${r.name}">` : ''}
        <div>
          <div class="fw-bold">${r.name}</div>
          <div class="text-muted small">#${r.id}</div>
        </div>
      </div>
      <div>
        <button class="btn btn-sm btn-outline-danger" onclick="delBrand(${r.id})">מחיקה</button>
      </div>
    </div>`).join('');
}
async function delBrand(id){
  if(!confirm('למחוק מותג?')) return;
  const fd = new FormData(); fd.append('action','delete'); fd.append('id',id);
  const res = await fetch('/api/brands.php', {method:'POST', body: fd});
  const j = await res.json(); if(j.ok) loadBrands(); else alert(j.msg||'שגיאה');
}
document.getElementById('brand-form').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData(e.currentTarget);
  fd.append('action','create');
  const res = await fetch('/api/brands.php', {method:'POST', body: fd});
  const j = await res.json();
  if(j.ok){ e.currentTarget.reset(); loadBrands(); }
  else alert(j.msg||'שגיאה');
});
loadBrands();
</script>
</body>
</html>
