<?php
// api/brands.php – simple brand CRUD with image & crop
declare(strict_types=1);
include '../includes/Conn.php';
include '../includes/cms/session.php';
require_once '../includes/image_utils.php';

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? $_GET['action'] ?? '';
$relDir = '/uploads/brands';
$absDir = $_SERVER['DOCUMENT_ROOT'].$relDir;
if (!is_dir($absDir)) @mkdir($absDir,0775,true);

$out = ['ok'=>false];

try {
    switch ($action) {
        case 'list':
            $rows = [];
            $rs = $conn->query("SELECT id, name, img, img_226, img_tiny FROM brands ORDER BY name ASC");
            while ($r = $rs->fetch_assoc()) $rows[] = $r;
            $out = ['ok'=>true, 'rows'=>$rows];
            break;

        case 'create':
            $name = trim($_POST['name'] ?? '');
            if ($name==='') throw new Exception('Missing name');
            $imgRel = null; $img226=null; $imgTiny=null;
            if (!empty($_FILES['file']['tmp_name'])) {
                $r = imgutils_save_upload($_FILES['file'],$absDir,$relDir);
                if (!$r['ok']) throw new Exception($r['msg'] ?? 'upload failed');
                $base = basename($r['rel']);
                $v = imgutils_generate_variants($absDir,$relDir,$base,true);
                $imgRel = $r['rel']; $img226=$v['thumb_226']; $imgTiny=$v['tiny_10'];
            }
            $stmt = $conn->prepare("INSERT INTO brands (name,img,img_226,img_tiny) VALUES (?,?,?,?)");
            $stmt->bind_param('ssss',$name,$imgRel,$img226,$imgTiny);
            $stmt->execute();
            $out = ['ok'=>true, 'id'=>$conn->insert_id];
            break;

        case 'update':
            $id   = intval($_POST['id'] ?? 0);
            $name = trim($_POST['name'] ?? '');
            if (!$id) throw new Exception('Bad id');
            $stmt = $conn->prepare("UPDATE brands SET name=? WHERE id=?");
            $stmt->bind_param('si',$name,$id);
            $stmt->execute();
            $out = ['ok'=>true];
            break;

        case 'delete':
            $id = intval($_POST['id'] ?? 0);
            if (!$id) throw new Exception('Bad id');
            $stmt = $conn->prepare("SELECT img,img_226,img_tiny FROM brands WHERE id=?");
            $stmt->bind_param('i',$id); $stmt->execute();
            $b = $stmt->get_result()->fetch_assoc();
            $conn->query("DELETE FROM brands WHERE id=$id");
            foreach (['img','img_226','img_tiny'] as $k) {
                if (!empty($b[$k])) @unlink($_SERVER['DOCUMENT_ROOT'].$b[$k]);
            }
            $out = ['ok'=>true];
            break;

        default:
            throw new Exception('Unknown action');
    }
} catch (Throwable $e) {
    $out = ['ok'=>false,'msg'=>$e->getMessage()];
}

echo json_encode($out, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
