   <?php
   include '../../includes/Conn.php';
   ?>
   document.addEventListener('DOMContentLoaded', function () {
            // 1. Query all elements first
            var amountSlider = document.getElementById('loan-amount-slider');
            var amountInput = document.getElementById('loan-amount');
            var amountDisplay = document.getElementById('loan-amount-display');
            var termSlider = document.getElementById('loan-term-slider');
            var termInput = document.getElementById('loan-term');
            var termDisplay = document.getElementById('loan-term-display');
            var resultDiv = document.getElementById('loan-monthly-pay');
            var contactDiv = document.getElementById('loan-contact-actions');
            var rateInput = document.getElementById('loan-rate');
            var hasShownContact = false;

            // 2. Define calculateLoan *before* assigning slider events!
            window.calculateLoan = function () {
                const amount = Number(amountInput.value);
                const term = Number(termInput.value);
                // Defensive: rateInput might not exist in some PHP setups
                let rate = 0.0<?=$yearly_interest ?>;
                if (rateInput) rate = Number(rateInput.value) / 100;

                if (amount && term && rate > 0) {
                    const monthlyRate = rate / 12;
                    const monthlyPay = amount * monthlyRate / (1 - Math.pow(1 + monthlyRate, -term));
                    resultDiv.innerText =
                        monthlyPay.toLocaleString('he-IL', { style: 'currency', currency: 'ILS', minimumFractionDigits: 0, maximumFractionDigits: 0 });

                    if (!hasShownContact) {
                        contactDiv.style.display = 'flex';
                        hasShownContact = true;
                    }
                } else {
                    resultDiv.innerText = '₪0';
                    contactDiv.style.display = 'none';
                    hasShownContact = false;
                }
            }

            // 3. Now create sliders and set up update events
            noUiSlider.create(amountSlider, {
                start: [50000],
                step: 1000,
                connect: [true, false],
                direction: 'rtl',
                range: { 'min': 15000, 'max': 600000 },
                tooltips: false
            });
            amountSlider.noUiSlider.on('update', function (values, handle) {
                var val = Math.round(values[handle]);
                amountDisplay.textContent = '₪' + val.toLocaleString('he-IL');
                amountInput.value = val;
                calculateLoan();
            });

            noUiSlider.create(termSlider, {
                start: [48],
                step: 1,
                connect: [true, false],
                direction: 'rtl',
                range: { 'min': 12, 'max': 100 },
                tooltips: false
            });
            termSlider.noUiSlider.on('update', function (values, handle) {
                var val = Math.round(values[handle]);
                termDisplay.textContent = val;
                termInput.value = val;
                calculateLoan();
            });

            // 4. Reset
            document.getElementById('loan-calc-form').onreset = function () {
                amountSlider.noUiSlider.set(50000);
                termSlider.noUiSlider.set(48);
                resultDiv.innerText = '₪0';
                contactDiv.style.display = 'none';
                hasShownContact = false;
            };

            // 5. On page load, set result and hide contacts
            calculateLoan();
        });