/* app/js/image-editor.js – inline crop + pad + previews + safe modal */
(function(){
  const $ = (sel, root=document)=>root.querySelector(sel);
  const $$ = (sel, root=document)=>Array.from(root.querySelectorAll(sel));

  // Prevent crop modal from closing when clicking outside
  document.addEventListener('click', (e)=>{
    const modal = $('.modal.show');
    if (modal && !modal.contains(e.target) && !e.target.closest('.modal')) {
      // do nothing: block accidental close
      e.stopPropagation();
    }
  }, true);

  // If using Bootstrap 5, set static backdrop
  if (window.bootstrap) {
    $$('.modal').forEach(m => {
      m.addEventListener('show.bs.modal', (ev)=>{
        const inst = bootstrap.Modal.getOrCreateInstance(m, {backdrop:'static', keyboard:false});
      });
    });
  }

  // Uploader handler
  async function postForm(url, formData) {
    const res = await fetch(url, {method:'POST', body: formData});
    return await res.json();
  }

  function setPreview(container, src, t226, tiny) {
    if (!container) return;
    container.innerHTML = `
      <div class="grid grid-cols-3 gap-10">
        <div>
          <div class="text-sm mb-2">תמונה מקורית / מעודכנת</div>
          <img src="${src}" style="max-width:100%;border:1px solid #eee;border-radius:8px" />
        </div>
        <div>
          <div class="text-sm mb-2">226×226</div>
          <img src="${t226}" width="226" height="226" style="border:1px solid #eee;border-radius:8px" />
        </div>
        <div>
          <div class="text-sm mb-2">10×10 (טעינה)</div>
          <img src="${tiny}" width="40" height="40" style="image-rendering:pixelated;border:1px solid #eee;border-radius:8px" />
        </div>
      </div>`;
  }

  window.ImageEditor = {
    async upload(input, previewBoxSelector) {
      const fd = new FormData();
      if (!input.files || !input.files[0]) return;
      fd.append('action','upload');
      fd.append('file', input.files[0]);
      const json = await postForm('/api/image.php', fd);
      if (json.ok) {
        setPreview($(previewBoxSelector), json.src, json.thumb_226, json.tiny_10);
        const hidden = input.closest('form')?.querySelector('input[name="image_full"]');
        if (hidden) hidden.value = json.src;
        const h226 = input.closest('form')?.querySelector('input[name="image_226"]');
        if (h226) h226.value = json.thumb_226;
        const h10  = input.closest('form')?.querySelector('input[name="image_tiny"]');
        if (h10) h10.value = json.tiny_10;
        // Show inline crop
        const img = $('#inline-crop-img');
        if (img) {
          img.src = json.src + '?v=' + Date.now();
          if (window._cropper) { window._cropper.destroy(); }
          window._cropper = new Cropper(img, {viewMode:1, aspectRatio:1, autoCropArea:0.9});
        }
      } else { alert(json.msg || 'שגיאת העלאה'); }
    },

    async applyCrop(previewBoxSelector) {
      if (!window._cropper) return;
      const data = window._cropper.getData(true);
      const fd = new FormData();
      const src = $('#inline-crop-img')?.getAttribute('src')?.split('?')[0];
      fd.append('action','crop');
      fd.append('src', src);
      fd.append('x', Math.round(data.x));
      fd.append('y', Math.round(data.y));
      fd.append('w', Math.round(data.width));
      fd.append('h', Math.round(data.height));
      const json = await postForm('/api/image.php', fd);
      if (json.ok) {
        setPreview($(previewBoxSelector), json.src, json.thumb_226, json.tiny_10);
        // update hidden inputs
        const form = $('#product-form');
        if (form) {
          form.image_full.value = json.src;
          form.image_226.value  = json.thumb_226;
          form.image_tiny.value = json.tiny_10;
        }
        $('#inline-crop-img').src = json.src + '?v=' + Date.now();
      } else alert(json.msg || 'שגיאת חיתוך');
    },

    async padSquare(previewBoxSelector) {
      const src = $('#inline-crop-img')?.getAttribute('src')?.split('?')[0];
      if (!src) return;
      const fd = new FormData();
      fd.append('action','pad_to_square');
      fd.append('src', src);
      const json = await postForm('/api/image.php', fd);
      if (json.ok) {
        setPreview($(previewBoxSelector), json.src, json.thumb_226, json.tiny_10);
        const form = $('#product-form');
        if (form) {
          form.image_full.value = json.src;
          form.image_226.value  = json.thumb_226;
          form.image_tiny.value = json.tiny_10;
        }
        $('#inline-crop-img').src = json.src + '?v=' + Date.now();
      } else alert(json.msg || 'שגיאת ריווח לבן');
    }
  };

})();