/*  =========  modalUtil =========
 *  alert(msg , type)      – info/success/error  → Promise
 *  confirm(msg , cb)      – חלון אישור
 *  open(opts)             – שימוש חופשי (ראה מתחת)
 *  close()                – סגירה ידנית
 */
window.modalUtil = (function(){
    const $modal  = $('#storyModal');
    let   resolvePromise=null;

    /* סגירה */
    function close(){
        $modal.fadeOut(120,()=>{ $('.modal-box storyModal',$modal).empty(); });
        if(resolvePromise){ resolvePromise(); resolvePromise=null; }
    }

    /* פתיחה כללית */
    function open({title='',body='',buttons=[{text:'סגור'}]}){
        const $box = $('.modal-box',$modal).empty();
        $('<h3>',{class:'modal-title',text:title}).appendTo($box);
        $('<div>',{class:'modal-body',html:body}).appendTo($box);
        const $btnBox=$('<div>',{class:'modal-buttons'}).appendTo($box);

        buttons.forEach(b=>{
           $('<button>',{
               text : b.text,
               class:'sc-button '+(b.class||'btn-info'),
               click : ev=>{
                   ev.preventDefault();
                   if(typeof b.callback==='function') b.callback();
                   if(b.close!==false) close();
               }
           }).appendTo($btnBox);
        });
        $modal.fadeIn(120);

        /* החזר Promise */
        return new Promise(res=>{ resolvePromise=res; });
    }

    /* הודעה פשוטה */
    function alert(msg,type='info'){
        const caption={success:'הצלחה',error:'שגיאה',info:'מידע'}[type]||'מידע';
        const cls    ={success:'btn-ok',error:'btn-err',info:'btn-info'}[type]||'btn-info';
        return open({
            title:caption,
            body :`<p>${msg}</p>`,
            buttons:[{text:'אישור',class:cls}]
        });
    }

    /* אישור */
    function confirm(msg,cb){
        return open({
            title:'אישור פעולה',
            body:`<p>${msg}</p>`,
            buttons:[
                {text:'ביטול',class:'btn-cancel'},
                {text:'אישור',class:'btn-ok',callback:cb}
            ]
        });
    }

    return {open,close,alert,confirm};
})();
