-- 2025-09-06 Admin image and metadata upgrades

-- 1) Brands
CREATE TABLE IF NOT EXISTS brands (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(190) NOT NULL,
  img VARCHAR(255) NULL,
  img_226 VARCHAR(255) NULL,
  img_tiny VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 2) Products – new columns (ignore errors if exist)
ALTER TABLE shop_products
  ADD COLUMN IF NOT EXISTS brand_id INT NULL,
  ADD COLUMN IF NOT EXISTS life_stage ENUM('גור','בוגר','מבוגר','שלושתם') DEFAULT 'שלושתם',
  ADD COLUMN IF NOT EXISTS is_medical_food TINYINT(1) NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS image_full VARCHAR(255) NULL,
  ADD COLUMN IF NOT EXISTS image_226 VARCHAR(255) NULL,
  ADD COLUMN IF NOT EXISTS image_tiny VARCHAR(255) NULL;

ALTER TABLE shop_products
  ADD INDEX IF NOT EXISTS idx_brand_id (brand_id),
  ADD INDEX IF NOT EXISTS idx_life_stage (life_stage),
  ADD INDEX IF NOT EXISTS idx_is_medical_food (is_medical_food);

ALTER TABLE shop_products
  ADD CONSTRAINT fk_products_brand
  FOREIGN KEY (brand_id) REFERENCES brands(id)
  ON UPDATE CASCADE ON DELETE SET NULL;
