<?php
/*-------------------------------------------------
|  DELETE PRODUCT RECORD  (+ clean-up of images)
|  url: delete_product.php?id=123
|  identical flow to delete_car.php – only names changed
-------------------------------------------------*/
include './includes/Conn.php';
include './includes/session.php';     // keep your auth / login checks here

/* 1)  Validate ID -------------------------------------------------------*/
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$id) {
    header('Location: my-products.php?err=bad_id');
    exit;
}

/* 2)  Fetch record – we need the image paths for file-unlink ------------*/
$stmt = $conn->prepare(
    "SELECT images, gallery
       FROM shop_products
      WHERE id = ?"
);
$stmt->bind_param('i', $id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {                      // nothing found
    header('Location: my-products.php?err=not_found');
    exit;
}

/* 3)  OPTIONAL permission check  ---------------------------------------*/
/*
if ($_SESSION['user_id'] !== $product['owner_id']) {
    header('Location: my-products.php?err=no_perm');
    exit;
}
*/

/* 4)  Delete DB rows (product + per-unit prices) ------------------------*/
$conn->query("DELETE FROM shop_products       WHERE id = $id");
$conn->query("DELETE FROM shop_product_prices WHERE product_id = $id");

/* 5)  Delete physical files (main + gallery) ---------------------------*/
$allPics = [];
if (!empty($product['images']))   $allPics[] = $product['images'];
if (!empty($product['gallery'])) {
    $g = json_decode($product['gallery'], true);
    if (is_array($g)) $allPics = array_merge($allPics, $g);
}

foreach ($allPics as $pic) {
    // normalise → only delete inside /uploads
    $local = str_replace(['http://', 'https://', $_SERVER['HTTP_HOST']], '', $pic);
    $abs   = __DIR__ . '/' . ltrim($local, '/');
    if (is_file($abs) &&                 // file exists
        strpos(realpath($abs),           // and path is inside /uploads
               realpath(__DIR__ . '/uploads')) === 0) {
        @unlink($abs);
    }
}

/* 6)  Redirect back with a flash msg -----------------------------------*/
header('Location: my-products.php?msg=deleted');
exit;


/* Extra cleanup for image variants */
try {
    $stmt = $conn->prepare("SELECT image_full,image_226,image_tiny FROM shop_products WHERE id=?");
    $stmt->bind_param('i', $id); $stmt->execute();
    $p = $stmt->get_result()->fetch_assoc();
    foreach (['image_full','image_226','image_tiny'] as $k) {
        if (!empty($p[$k])) @unlink($_SERVER['DOCUMENT_ROOT'].$p[$k]);
    }
} catch (Throwable $e) {}
