<?php
error_reporting(1); // maximum error reporting
ini_set('display_errors', '1');

// ================================
// פרטי חיבור למסד הנתונים
// ================================
$mysqlDB = "comark_shop";
$userDB  = "root";
$conn    = new mysqli('localhost', $userDB, 'Raiadv@11', $mysqlDB);

if ($conn->connect_errno) {
    printf("Connect failed: %s\n", $conn->connect_error);
    exit();
}
global $conn;

// ===========================// in includes/Conn.php, right after you do new mysqli(...)
mysqli_set_charset($conn, 'utf8mb4');

// הגדרות כלליות של האתר
// ================================
$static_files_domain = "http://tan.localhost/";
// === car-types.php ===
$CAR_TYPES = [
    'רכבי פנאי',   // SUV
    'ארבע על ארבע',// 4×4
    'פרטי',        // Private
    'קטן',         // Small
    'קופה',        // Coupe
    'טנדר',        // Pickup
];

/* ====== CONFIG ====== */
$ICONS_BASE   = '/assets/svg/';  // אם icon = 'file.svg' → נשתמש /assets/svg/file.svg
$LIMIT_CATS   = 8;               // 8 קוביות
$INIT_LIMIT   = 12;              // כמה מוצרים בטעינה ראשונה
$CHUNK_LIMIT  = 6;              // כמה מוצרים בכל "טען עוד"
$cardsPerTab  = $INIT_LIMIT;     // תאימות לשם שקיים אצלך (לא חובה יותר)

/* מפת איקונים אופציונלית (תגבר על ה־DB אם חסר) */
$ICON_MAP = [
  'בעלי כנף' => 'bird.svg',
  'חתולים'   => 'cat.svg',
  'כלבים'    => 'dog.svg',
  'סוסים'    => 'horse.svg',
  'פרות'     => 'cow.svg',
  'עגלים'    => 'cow.svg',
  'תרנגולות' => 'chicken.svg',
  'עזים'     => 'goat.svg',
];
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }



// ================================
// פונקציות עזר
// ================================

function product_thumb_url(?string $raw): string{ $placeholder = '/assets/images/dashboard/default-product.jpg'; if (!$raw) return $placeholder; $url = '/' . ltrim($raw, '/'); $rel = ltrim($url, '/'); if (strpos($rel, 'uploads/library/') === 0) { $dir = dirname($rel); $file = basename($rel); $thumbRel = $dir.'/_thumbs/'.$file; $thumbAbs = $_SERVER['DOCUMENT_ROOT'].'/'.$thumbRel; if (is_file($thumbAbs)) return '/'.$thumbRel; } return $url; }
function get_product_min_price_and_options(mysqli $conn, int $productId){ $stmt = $conn->prepare(" SELECT weight, unit, price, barcode FROM shop_product_prices WHERE product_id = ? ORDER BY unit, weight "); $stmt->bind_param('i', $productId); $stmt->execute(); $rows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC); $min = null; foreach ($rows as $r) { $p = (float)$r['price']; if ($min === null || $p < $min) $min = $p; } return [$min, $rows]; }
function calc_monthly_payment($principal, $months, $annual_rate_percent) {
    $monthly_rate = $annual_rate_percent / 12 / 100;
    if ($monthly_rate > 0) {
        return $principal * ($monthly_rate * pow(1 + $monthly_rate, $months)) 
             / (pow(1 + $monthly_rate, $months) - 1);
    } else {
        return $principal / $months;
    }
}

function getSiteSettings(): array {
    global $conn;
    $sql = "SELECT * 
            FROM cardealer_settings 
            WHERE id = 1 
            LIMIT 1";
    $res = $conn->query($sql);
    if (! $res) {
        trigger_error("DB Error: " . $conn->error, E_USER_WARNING);
        return [];
    }
    $row = $res->fetch_assoc();
    return $row ?: [];
}

// ================================
// טען הגדרות האתר
// ================================
$settings        = getSiteSettings();

// 2) prepare the three metas + share-image URL
$description = htmlspecialchars($settings['main_page_description'], ENT_QUOTES, 'UTF-8');
$keywords    = htmlspecialchars($settings['main_page_keywords'],    ENT_QUOTES, 'UTF-8');


//print_R($settings);
$rate            = floatval($settings['interest_rate']);
$yearly_interest = ($rate == floor($rate)) ? (int)$rate : $rate;
$footerLinks     = json_decode($settings['footer_links'], true);
$companyName     = $settings['site_title'];

// ================================
// שליפת עמודים להצגה בפוטר
// ================================
$sql    = "
    SELECT title, slug
    FROM static_pages
    WHERE show_in_footer = 1
      AND is_active = 1
    ORDER BY id ASC
";
$result = $conn->query($sql);
$pages  = [];

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $pages[] = $row;
    }
    $result->free();
}

function storeImageVariants(array $file, string $absDir, string $relDir): array {
    // Store original
    $origPath = storeFile($file, $absDir, $relDir);
    if (!$origPath) return [];

    $fullPath = "$absDir/" . basename($origPath);
    list($width, $height, $type) = getimagesize($fullPath);
    switch ($type) {
        case IMAGETYPE_JPEG: $create = 'imagecreatefromjpeg'; $save = 'imagejpeg'; break;
        case IMAGETYPE_PNG:  $create = 'imagecreatefrompng';  $save = 'imagepng';  break;
        case IMAGETYPE_GIF:  $create = 'imagecreatefromgif';  $save = 'imagegif';  break;
        default: return [ 'original' => $origPath ];
    }

    $img = $create($fullPath);
    $variants = ['original' => $origPath];

    // 1) Thumbnail 235x176
    $thumbW = 235; $thumbH = 176;
    $thumb = imagecreatetruecolor($thumbW, $thumbH);
    imagecopyresampled($thumb, $img, 0,0, 0,0, $thumbW,$thumbH, $width,$height);
    $thumbName = 's_' . basename($origPath);
    $thumbPath = "$absDir/" . $thumbName;
    $save($thumb, $thumbPath);
    chmod($thumbPath, 0664);
    $variants['thumb'] = "$relDir/" . $thumbName;

    // 2) Medium width 958.6px, proportional height
    $medW = 959; // round
    $medH = intval($height * ($medW / $width));
    $med = imagecreatetruecolor($medW, $medH);
    imagecopyresampled($med, $img, 0,0, 0,0, $medW,$medH, $width,$height);
    $medName = 'm_' . basename($origPath);
    $medPath = "$absDir/" . $medName;
    $save($med, $medPath);
    chmod($medPath, 0664);
    $variants['medium'] = "$relDir/" . $medName;

    imagedestroy($img);
    imagedestroy($thumb);
    imagedestroy($med);

    return $variants;
}

?>
