<!-- Container: קוביות קטגוריות — בשולחן עבודה שורה אחת, ובנייד שורה נגללת אופקית -->
<div class="container my-4" dir="rtl">

  <style>
    /* גלילה אופקית בנייד, שורה אחת בשולחן עבודה */
    .cat-scroll {
      overflow-x: auto;
      -webkit-overflow-scrolling: touch;
      scroll-snap-type: x mandatory;
      padding-bottom: .5rem;
    }
    .cat-track {
      display: flex;
      gap: .75rem;
    }
    .cat-card {
      scroll-snap-align: start;
      flex: 0 0 42vw;                /* רוחב כרטיס בנייד */
      max-width: 220px;
      aspect-ratio: 1 / 1;           /* ריבוע */
      background: #fff;
      border: 1px solid rgba(0,0,0,.08);
      border-radius: 1rem;
      padding: 1rem;
      display: flex;
      flex-direction: column;
      justify-content: space-between; /* טקסט למעלה, תמונה למטה */
      align-items: center;
      text-align: center;
      box-shadow: 0 .125rem .25rem rgba(0,0,0,.05);
      text-decoration: none;
      color: inherit;
      transition: transform .18s ease, box-shadow .18s ease;
    }
    .cat-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 .5rem 1rem rgba(0,0,0,.08);
    }
    .cat-card .label {
      font-weight: 600;
      font-size: 1rem;
    }
    .cat-card img {
      max-width: 72%;
      height: auto;
      display: block;
    }

    /* מסכים גדולים: שורה אחת של 8 עמודות, ללא גלילה */
    @media (min-width: 992px) {
      .cat-scroll { overflow: visible; }
      .cat-track {
        display: grid;
        grid-template-columns: repeat(8, 1fr);
        gap: 1rem;
      }
      .cat-card { flex: initial; max-width: none; }
    }
  </style>

  <div class="cat-scroll">
    <div class="cat-track">

      <a href="#birds" class="cat-card">
        <div class="label">בעלי כנף</div>
        <img src="/assets/svg/bird.svg" alt="בעלי כנף">
      </a>

      <a href="#cats" class="cat-card">
        <div class="label">חתולים</div>
        <img src="/assets/svg/cat.svg" alt="חתולים">
      </a>

      <a href="#dogs" class="cat-card">
        <div class="label">כלבים</div>
        <img src="/assets/svg/dog.svg" alt="כלבים">
      </a>

      <a href="#horses" class="cat-card">
        <div class="label">סוסים</div>
        <img src="/assets/svg/horse.svg" alt="סוסים">
      </a>

      <a href="#cows" class="cat-card">
        <div class="label">פרות</div>
        <img src="/assets/svg/cow.svg" alt="פרות">
      </a>

      <a href="#calves" class="cat-card">
        <div class="label">עגלים</div>
        <img src="/assets/svg/cow.svg" alt="עגלים">
      </a>

      <a href="#chicken" class="cat-card">
        <div class="label">תרנגולות</div>
        <img src="/assets/svg/chicken.svg"
             onerror="this.onerror=null;this.src='/assets/svg/bird.svg';"
             alt="תרנגולות">
      </a>

      <a href="#goats" class="cat-card">
        <div class="label">עזים</div>
        <img src="/assets/svg/goat.svg"
             onerror="this.onerror=null;this.src='/assets/svg/cow.svg';"
             alt="עזים">
      </a>

    </div>
  </div>
</div>
