<?php
include './includes/cms/session.php';
include "./includes/Conn.php";
if (isset($_GET)) {
    $listing_only = $_GET['module'];
} else {
    $listing_only = true;

}

// ✅ How many results per page
$limit = 150;

// ✅ Get current page or set default to 1
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;

// ✅ Calculate offset
$offset = ($page - 1) * $limit;
/* ✅ קריאת פילטרים מה-URL */
$flt_make = isset($_GET['make_id']) ? (int) $_GET['make_id'] : 0;
$flt_model = isset($_GET['main_id']) ? (int) $_GET['main_id'] : 0;
$flt_type = isset($_GET['product_type']) ? trim($_GET['product_type']) : '';

/* ✅ בסיס ה-WHERE הדינמי */
$where = [];
$bind = [];
$types = '';

if ($flt_make) {
    $where[] = 'c.subcategory = ?';
    $bind[] = $flt_make;
    $types .= 'i';
}
if ($flt_model) {
    $where[] = 'c.category = ?';
    $bind[] = $flt_model;
    $types .= 'i';
}
if ($flt_type) {
    $where[] = 'c.product_type  = ?';
    $bind[] = $flt_type;
    $types .= 's';
}

$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

/* ✅ ספירה לצורכי פאגינציה */
$count_sql = "SELECT COUNT(*) AS total
              FROM shop_products c
              $where_sql";
$stmt_cnt = $conn->prepare($count_sql);
if ($types)
    $stmt_cnt->bind_param($types, ...$bind);
$stmt_cnt->execute();
$total_rows = $stmt_cnt->get_result()->fetch_assoc()['total'];

/* ✅ חישוב עמודים והצמדה לטווח תקין */
$total_pages = (int) max(1, ceil($total_rows / $limit));
$page = max(1, min($page, $total_pages));
$offset = ($page - 1) * $limit; // חשוב לעדכן לפני ה-SELECT עם LIMIT/OFFSET

/* ✅ שליפת הנתונים */
/* ---------- SELECT the data you actually have ---------- */
$sql = "
    SELECT  c.id,
            c.title_he,
            c.images,
            c.date_added,
            c.status,                                   -- enum('publish','hidden','sold','pending')
            m.id                AS make_id,             -- lets you keep make-/model-filters by ID
            m.category_name     AS category_name,
            mo.id               AS model_id,
            mo.sub_category_name
    FROM    shop_products           AS c
    LEFT JOIN shop_categories        AS m  ON c.category = m.id
    LEFT JOIN shop_sub_categories    AS mo ON c.subcategory   = mo.id
    $where_sql
    ORDER BY c.date_added DESC
    LIMIT  ?  OFFSET  ?";


$stmt = $conn->prepare($sql);

/* ‏‎$bind + ‎LIMIT‎ + ‎OFFSET‎ */
$types_all = $types . 'ii';
$bind_all = array_merge($bind, [$limit, $offset]);
$stmt->bind_param($types_all, ...$bind_all);

$stmt->execute();
$result = $stmt->get_result();

$tot  = (int)$conn->query("SELECT COUNT(*) n FROM shop_products")->fetch_assoc()['n'];
$sold = (int)$conn->query("SELECT COUNT(*) n FROM shop_products WHERE status='sold'")->fetch_assoc()['n'];
$hid  = (int)$conn->query("SELECT COUNT(*) n FROM shop_products WHERE status='hidden'")->fetch_assoc()['n'];
$pend = (int)$conn->query("SELECT COUNT(*) n FROM shop_products WHERE status='pending'")->fetch_assoc()['n'];

/* כמה מודעות מותרות?  (אם אין לך מגבלה אפשר להשמיט) */
$quota = 50;
$remain = max($quota - $tot, 0);
?>


<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?php echo $site_name ?> - רשימת מוצרים במלאי </title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">

</head>

<script src="/app/js/image-editor.js"></script>



<body class="body">


<!-- 🔎 AJAX חיפוש + כמה מוצרים לדף -->
<div class="d-flex gap-2 align-items-center my-3">
  <input id="search-box" type="search" class="form-control" placeholder="חיפוש לפי שם/מק\"ט">
  <select id="per-page" class="form-select" style="max-width:140px">
    <option value="25">25</option>
    <option value="50" selected>50</option>
    <option value="100">100</option>
    <option value="150">150</option>
    <option value="300">300</option>
  </select>
</div>
<div id="search-results"></div>
<script>
let timer = null;
async function doSearch(){
  const q = document.getElementById('search-box').value;
  const limit = document.getElementById('per-page').value;
  const res = await fetch(`/api/search_products.php?q=${encodeURIComponent(q)}&limit=${limit}`);
  const j = await res.json();
  if(!j.ok) return;
  const d = document.getElementById('search-results');
  d.innerHTML = j.rows.map(r=>`
    <div class="border rounded p-2 mb-2 d-flex justify-content-between align-items-center">
      <div class="d-flex gap-2 align-items-center">
        ${r.image_226 ? `<img src="${r.image_226}" width="60" height="60" class="rounded">` : ''}
        <div>
          <div class="fw-bold">${r.title_he || ''}</div>
          <div class="text-muted small">#${r.id} · ${r.status || ''}</div>
        </div>
      </div>
      <div>
        <a href="add-product.php?id=${r.id}" class="btn btn-sm btn-outline-primary">עריכה</a>
      </div>
    </div>`).join('');
}
document.getElementById('search-box').addEventListener('input', ()=>{
  clearTimeout(timer); timer=setTimeout(doSearch, 250);
});
document.getElementById('per-page').addEventListener('change', doSearch);
</script>




    <!-- dashboard -->
    <div class="dashboard-overlay"></div>
    <?php include './includes/cms/aside.php'; ?>

    <div id="wrapper-dashboard">
        <div id="pagee" class="clearfix">

            <?php include './includes/cms/header.php'; ?>

        </div>

        <div id="themesflat-content">
            <div class="dashboard-toggle">Show DashBoard</div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-area">
                            <main id="main" class="main-content">
                                <div class="tfcl-dashboard">

                                    <?php
                                    if ($listing_only == false AND !isset($_GET['make_id'])) {
                                        ?>
                                        <header class="topbar">
                                            <h1>לוח בקרה</h1>
                                        </header>

                                        <!-- ===== DASHBOARD OVERVIEW ===== -->
                                        <div class="tfcl-dashboard-overview ">
                                            <div class="row g-4">
                                                <!-- g-4 = מרווחים; שים לב ש-Bootstrap RTL צריך dir=rtl בהורה -->
                                                <!-- 1. Your listings -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview1.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>מוצרים בקטלוג</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <div class="listing-text d-flex">
                                                                        <b><?= $tot ?></b>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <!-- 2. Pending -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php?filter=pending">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview4.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>ממתינות</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <span><b><?= $pend ?></b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <!-- 3. Hidden -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php?filter=hidden">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview3.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>מוסתרות</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <span><b><?= $hid ?></b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <!-- 4. Sold -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php?filter=sold">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview2.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>נמכרו</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <span><b><?= $sold ?></b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div><!-- /.row -->
                                        </div><!-- /.tfcl-dashboard-overview -->
                                        <?php
                                    } else {
                                        ?>


                                        <h1 class="admin-title mb-3"><?= htmlspecialchars($settings['site_title'], ENT_QUOTES, 'UTF-8') ?> - קטלוג מוצרים</h1>


                                        <?php
                                    }
                                    ?>


                                    <div class="tfcl-dashboard-middle mt-2">
                                        <div class="row">
                                            <div class="tfcl-dashboard-middle-left col-md-12">
                                                <div class="tfcl-dashboard-listing">


                                                    <form id="filterForm" class="row g-2 mb-3" method="GET" action="">
                                                        <!-- ‎1. יצרן -->
                                                        <div class="col-xl-3 col-lg-6">
                                                            <select name="make_id" id="f-category" class="form-control">
                                                                <option value="">כל הקטגוריות</option>
                                                                <?php
                                                                $makes_opt = $conn->query("SELECT id,category_name FROM shop_categories ORDER BY category_name");
                                                                while ($m = $makes_opt->fetch_assoc()):
                                                                    ?>
                                                                    <option value="<?= $m['id'] ?>"
                                                                        <?= $m['id'] == $flt_make ? 'selected' : '' ?>>
                                                                        <?= $m['category_name'] ?>
                                                                    </option>
                                                                <?php endwhile; ?>
                                                            </select>
                                                        </div>

                                                        <!-- ‎2. דגם (מתמלא דינמית) -->
                                                        <div class="col-xl-3 col-lg-6">
                                                            <select name="main_id" id="f-sub-category" class="form-control">
                                                                <option value="">כל התת-קטגוריות</option>
                                                                <!-- אופציות ייטענו ב-JS -->
                                                            </select>
                                                        </div>

                                                        <!-- ‎3. סוג מוצר -->
                                                        <div class="col-xl-3 col-lg-6">
                                                            <select name="product_type" class="form-control">
                                                                <option value="">כל הסוגים</option>
                                                                <?php foreach (['SUV', '4x4', 'Private', 'Small', 'Coupe', 'Pickup'] as $t): ?>
                                                                    <option <?= $t == $flt_type ? 'selected' : '' ?>><?= $t ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>

                                                        <!-- ‎4. כפתור סינון -->
                                                        <div class="col-xl-3 col-lg-6 d-grid" >
 <div class="modal-footer group-button-submit d-flex align-items-center " >
                                                            <button class="pre-btn wide" type="submit">סנן</button>
                                                        </div>                                                        </div>
                                                    </form>




                                                    <div class="tfcl-table-listing">
                                                        <div class="table-responsive">
                                                            <span class="result-text">
                                                                <b><?= $total_rows ?></b> מוצרים במלאי 
                                                            </span>

                                                            <table class="table">
                                                                <thead>
                                                                    <tr>
                                                                        <th>פרטי מוצר</th>
                                                                        <th>מצב מודעה</th>
                                                                        <th>תאריך פרסום</th>
                                                                        <th>פעולות</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tfcl-table-content">

                                                                    <?php while ($car = $result->fetch_assoc()): ?>
                                                                        <tr>
                                                                            <!-- ✅ LISTING COLUMN -->
                                                                            <td class="column-listing">
                                                                                <div class="tfcl-listing-product">
                                                                                  
                                                                                    <a
                                                                                        href="add-product.php?id=<?= $car['id'] ?>">
                                                                                        <img src="<?= !empty($car['images']) ? str_replace($static_files_domain,"",$car['images']) : 'assets/images/dashboard/default-car.jpg' ?>"
                                                                                            alt="<?= $car['title_he'] . ' ' . $car['title_ar'] ?>"
                                                                                            width="100">
                                                                                    </a>
                                                                                    <div class="tfcl-listing-summary">
                                                                                          <h4 class="tfcl-listing-title">
                                                                                            <a
                                                                                                href="add-product.php?id=<?= $car['id'] ?>">
                                                                                                <?= $car['title_he'] . ' ' . $car['title_ar'] ?>
                                                                                            </a>
                                                                                        </h4>
                                                                                        <h4 class="tfcl-listing-title">
                                                                                            <a
                                                                                                href="add-product.php?id=<?= $car['id'] ?>">
                                                                                                <?= htmlspecialchars( $car['category_name'] . ', ' . $car['sub_category_name']) ?>
                                                                                            </a>
                                                                                        </h4>
                                                                                       
                                                                                        <div class="price">
                                                                                            <div
                                                                                                class="inner tfcl-listing-price">
                                                                                                ₪<?= number_format($car['price']) ?>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </td>

                                                                            <!-- ✅ STATUS COLUMN -->
                                                                            <td class="column-status">
                                                                                <span
                                                                                    class="tfcl-listing-status status-publish">
                                                                                    Approved
                                                                                </span>
                                                                            </td>

                                                                            <!-- ✅ POSTING DATE COLUMN -->
                                                                            <td class="column-date">
                                                                                <div class="tfcl-listing-date">
                                                                                    <?= date("F d, Y", strtotime($car['date_added'])) ?>
                                                                                </div>
                                                                            </td>

                                                                            <!-- ✅ ACTION COLUMN -->
                                                                            <td class="column-controller">
                                                                                <div class="inner-controller">
                                                                                    <span class="icon"><img
                                                                                            src="assets/images/dashboard/pen.svg"></span>
                                                                                    <a href="add-product.php?id=<?= $car['id'] ?>"
                                                                                        class="btn-action">עריכה</a>
                                                                                </div>
                                                                                <!--<div class="inner-controller">
                                                                                    <span class="icon"><img
                                                                                            src="assets/images/dashboard/plus-square.svg"></span>
                                                                                    <a href="#" data-id="<?= $car['id'] ?>"
                                                                                        class="btn-action btn-story">סטורי</a>
                                                                                </div>-->
                                                                                <div class="inner-controller">
                                                                                    <span class="icon"><img
                                                                                            src="assets/images/dashboard/trash.svg"></span>
                                                                                    <a href="delete_product.php?id=<?= $car['id'] ?>"
                                                                                        onclick="return confirm('למחוק?')"
                                                                                        class="btn-action">מחיקה</a>
                                                                                </div>
                                                                            </td>

                                                                        </tr>
                                                                    <?php endwhile; ?>

                                                                </tbody>
                                                            </table>
                                                        </div>

                                                     <!-- ✅ PAGINATION (Dynamic + keeps filters) -->
<div class="tfcl-pagination paging-navigation clearfix">
    <?php if ($page > 1): ?>
        <a class="prev page-numbers" href="<?= htmlspecialchars($baseQS) ?>page=<?= $page - 1 ?>">
            <i class="far fa-angle-right"></i>
        </a>
    <?php endif; ?>

    <?php
    // חלון דפים יפה: 2 שמאלה/ימינה מסביב לעמוד הנוכחי
    $start = max(1, $page - 2);
    $end   = min($total_pages, $page + 2);

    if ($start > 1) {
        echo '<a class="page-numbers" href="?' . htmlspecialchars($baseQS) . 'page=1">1</a>';
        if ($start > 2) echo '<span class="page-numbers dots">…</span>';
    }

    for ($i = $start; $i <= $end; $i++):
    ?>
        <a class="page-numbers <?= ($i == $page) ? 'current' : '' ?>"
           href="?<?= htmlspecialchars($baseQS) ?>page=<?= $i ?>"><?= $i ?></a>
    <?php endfor; ?>

    <?php
    if ($end < $total_pages) {
        if ($end < $total_pages - 1) echo '<span class="page-numbers dots">…</span>';
        echo '<a class="page-numbers" href="?' . htmlspecialchars($baseQS) . 'page=' . $total_pages . '">' . $total_pages . '</a>';
    }
    ?>

    <?php if ($page < $total_pages): ?>
        <a class="next page-numbers" href="?<?= htmlspecialchars($baseQS) ?>page=<?= $page + 1 ?>">
            <i class="far fa-angle-left"></i>
        </a>
    <?php endif; ?>
</div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </main>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php include './includes/cms/modales.php'; ?>

    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>
    <script src="app/js/jquery-ui.js"></script>
    <script src="app/js/dashboard.js"></script>
    <!-- modal story -->
    <div id="storyModal" class="modal">
        <div class="modal-box">
            <h3>יצירת סטורי (בהמשך…)</h3>
            <button id="storyOk" class="sc-button">סגור</button>
        </div>
    </div>

    <script>
        /* inline edit make/model -------------------------------------------------- */
        $('select.inline-edit').change(function () {
            $.post('api_update_car.php', {
                id: $(this).data('id'),
                field: $(this).data('field'),
                value: this.value
            });
        });

        /* story modal -------------------------------------------------------------*/
        $('.btn-story').click(function (e) {
            e.preventDefault();
            console.log('create story for car #' + $(this).data('id'));
            $('#storyModal').show();
        });
        $('#storyOk').click(() => $('#storyModal').hide());

        /* ----- מילוי דגם בהתאם ליצרן ----- */
        const MODELS = {};   // ייטען ב-AJAX פעם אחת
        $.getJSON('shop_ajax_cateory.php', { action: 'make_model_lists' }, res => {
            Object.assign(MODELS, res.models || {});
            fillModels($('#f-category').val());
        });

        /* שינוי יצרן */
        $('#f-category').on('change', function () {
            $('#f-sub-category').val('');    
            fillModels(this.value);
        });
        function fillModels(makeId) {
            const $md = $('#f-sub-category').empty()
                .append('<option value="">כל התת-קטגוריות</option>');
            (MODELS[makeId] || []).forEach(md => {
                $md.append(`<option value="${md.id}">${md.sub_category_name}</option>`);
            });
            /* שחזור בחירה אם חזרנו מ-GET */
            const sel = <?= (int) $flt_model ?>;
            if (sel) $md.val(sel);
        }

    </script>

</body>

</html>