<?php
// save_product.php – add / edit product + per-unit prices (with media library support)
include './includes/cms/session.php';
include './includes/Conn.php';
require_once './includes/image_utils.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST)) {
    die('No POST data');
}
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

/*-------------------------------------------------
| 1) SANITISE
-------------------------------------------------*/
$id = $_POST['product_id'] ?? null;
$g  = fn(string $k) => trim($_POST[$k] ?? '');
$life_stage = $g('life_stage');
$brand_id   = (int)($_POST['brand_id'] ?? 0);
$is_medical_food = isset($_POST['is_medical_food']) ? 1 : 0;
$image_full = $g('image_full');
$image_226  = $g('image_226');
$image_tiny = $g('image_tiny');


$title     = $g('title');
$title_he  = $g('title_he');
$title_ar  = $g('title_ar');
$catID     = (int)($_POST['main_id']  ?? 0);
$subID     = (int)($_POST['model_id'] ?? 0);

$desc      = $g('description');
$desc_he   = $g('description_he');
$desc_ar   = $g('description_ar');
$features  = $g('features');
$ing_he    = $g('ingredients_he');
$ing_ar    = $g('ingredients_ar');

/* names (legacy comment kept) */
$subcategory   = '';
$car_model_str = '';
if ($catID) {
    $subcategory = $conn->query(
        "SELECT category_name FROM shop_categories WHERE id = $catID"
    )->fetch_assoc()['category_name'] ?? '';
}
if ($subID) {
    $car_model_str = $conn->query(
        "SELECT sub_category_name FROM shop_sub_categories WHERE id = $subID"
    )->fetch_assoc()['sub_category_name'] ?? '';
}

/*-------------------------------------------------
| 2)  IMAGE  &  GALLERY
|    – supports:
|      * cropper (base64)
|      * direct file uploads
|      * picks from library (URLs)
|      * titles + order from gallery_titles_json
-------------------------------------------------*/
$old_gallery_raw = json_decode($_POST['old_gallery_json'] ?? '[]', true) ?: [];
// Normalize old gallery to array of URLs (old data might be array of strings or objects)
$old_gallery_urls = [];
foreach ($old_gallery_raw as $it) {
    if (is_string($it))         $old_gallery_urls[] = $it;
    elseif (is_array($it) && !empty($it['url'])) $old_gallery_urls[] = $it['url'];
}
$old_main    = $_POST['old_images'] ?? null;

if (!empty($_POST['delete_images'])) {
    $toDel       = array_map('trim', (array)$_POST['delete_images']);
    $old_gallery_urls = array_values(array_diff($old_gallery_urls, $toDel));
    if (in_array($old_main, $toDel, true)) {
        $old_main = $old_gallery_urls[0] ?? null;
    }
}

$abs = __DIR__ . '/uploads';
$rel = 'uploads';
if (!is_dir($abs)) mkdir($abs, 0775, true);

/* === Handle base64 image from cropper (main image) ==================== */
if (!empty($_POST['main_img_cropped'])) {
    $dataUrl = $_POST['main_img_cropped'];
    if (preg_match('/^data:image\/(\w+);base64,/', $dataUrl, $m)) {
        $ext  = strtolower($m[1]) === 'jpeg' ? 'jpg' : strtolower($m[1]);
        $data = base64_decode(substr($dataUrl, strpos($dataUrl, ',') + 1));
        $fn   = uniqid('img_', true) . ".$ext";
        file_put_contents("$abs/$fn", $data);
        chmod("$abs/$fn", 0664);

        // Pretend URL field was posted – keeps logic consistent
        $_POST['main_img_url']                 = "$rel/$fn";
        $_FILES['main_image_file']['name']     = '';
        $_FILES['main_image_file']['tmp_name'] = '';
        $_FILES['main_image_file']['error']    = UPLOAD_ERR_NO_FILE;
    }
}
/* ====================================================================== */

function storeFile(array $f, string $abs, string $rel): ?string
{
    if (!empty($f['error']) && $f['error'] !== UPLOAD_ERR_OK) return null;
    if (!isset($f['tmp_name']) || !is_uploaded_file($f['tmp_name'])) return null;

    $ext = strtolower(pathinfo($f['name'] ?? '', PATHINFO_EXTENSION));
    if (!preg_match('/^(jpg|jpeg|png|gif|webp)$/', $ext)) return null;

    $fn = uniqid('img_', true) . ".$ext";
    if (!move_uploaded_file($f['tmp_name'], "$abs/$fn")) return null;
    @chmod("$abs/$fn", 0664);
    return "$rel/$fn";
}

/* ---------------- MAIN IMAGE RESOLUTION ---------------- */
$mainImg = $old_main;

// 1) If user selected LIBRARY as source – take main_img_url_lib
$mainSource = $_POST['main_img_source'] ?? '';
if ($mainSource === 'library' && !empty($_POST['main_img_url_lib'])) {
    $mainImg = trim($_POST['main_img_url_lib']);
}
// 2) Else if uploaded a new file directly (not cropper)
elseif (!empty($_FILES['main_image_file']['name'] ?? '')) {
    $maybe = storeFile($_FILES['main_image_file'], $abs, $rel);
    if ($maybe) $mainImg = $maybe;
}
// 3) Else if cropper already saved URL into main_img_url
elseif (!empty($_POST['main_img_url'])) {
    $mainImg = $g('main_img_url');
}

/* ---------------- NEW UPLOADS FOR GALLERY (FILES) ---------------- */
$new_upload_urls = [];
if (!empty($_FILES['images']['name'][0] ?? '')) {
    foreach ($_FILES['images']['tmp_name'] as $i => $tmp) {
        $f = [
            'name'     => $_FILES['images']['name'][$i],
            'tmp_name' => $tmp,
            'error'    => $_FILES['images']['error'][$i],
        ];
        if ($u = storeFile($f, $abs, $rel)) $new_upload_urls[] = $u;
    }
}

/* ---------------- TITLES & ORDER FROM FRONTEND ----------------
   gallery_titles_json is an ordered array of {url,title} as seen in the UI.
   For newly uploaded images, the "url" in that JSON is a dataURL.
   Here we map those data: URLs to the actual saved file URLs by order.
-----------------------------------------------------------------*/
$front_items = json_decode($_POST['gallery_titles_json'] ?? '[]', true);
$final_gallery = [];  // array of ['url'=>..., 'title'=>...]
$used_upload_idx = 0;

if (is_array($front_items) && count($front_items)) {
    foreach ($front_items as $it) {
        $url = is_array($it) ? ($it['url'] ?? '') : '';
        $title = is_array($it) ? ($it['title'] ?? '') : '';

        if (!$url) continue;

        // If this is a data URL from a freshly uploaded file, map to saved URL
        if (strpos($url, 'data:') === 0) {
            if (isset($new_upload_urls[$used_upload_idx])) {
                $mapped = $new_upload_urls[$used_upload_idx++];
                $final_gallery[] = ['url' => $mapped, 'title' => $title];
            }
            // else: no file mapped (shouldn't happen), skip
        } else {
            // It's either old gallery URL or a library URL – keep as is.
            $final_gallery[] = ['url' => $url, 'title' => $title];
        }
    }
} else {
    // Fallback: no titles/order supplied → old gallery + new uploads appended
    foreach ($old_gallery_urls as $u) $final_gallery[] = ['url'=>$u, 'title'=>''];
    foreach ($new_upload_urls as $u) $final_gallery[] = ['url'=>$u, 'title'=>''];
}

/* ---------------- DEDUPLICATE (by url), LIMIT, MAIN IMAGE FIRST ---------------- */
$seen = [];
$dedup = [];
foreach ($final_gallery as $obj) {
    $u = $obj['url'] ?? '';
    if (!$u || isset($seen[$u])) continue;
    $seen[$u] = true;
    $dedup[] = ['url'=>$u, 'title'=>($obj['title'] ?? '')];
}

if ($mainImg && !isset($seen[$mainImg])) {
    // Prepend main image if not present
    array_unshift($dedup, ['url'=>$mainImg, 'title'=>($g('main_img_title') ?: '')]);
}

// Cap to 10
$dedup = array_slice($dedup, 0, 10);

// Ensure main image equals first gallery item
$mainImg = $dedup[0]['url'] ?? null;

// Encode gallery as objects (url,title)
$gJson   = json_encode($dedup, JSON_UNESCAPED_UNICODE);

/*-------------------------------------------------
| 3)  INSERT  /  UPDATE
-------------------------------------------------*/
if ($id) {
    /* -------- UPDATE -------- */
    $sql = "UPDATE shop_products SET
              title           = ?,
              title_he        = ?,
              title_ar        = ?,
              subcategory     = ?,
              category        = ?,
              description     = ?,
              description_he  = ?,
              description_ar  = ?,
              features        = ?,
              ingredients_he  = ?,
              ingredients_ar  = ?,
              images          = ?,
              gallery         = ?
            WHERE id = ?";
    $types = 'sssssssssssssi';
    $params = [
        $title, $title_he, $title_ar,
        $subID, $catID,
        $desc, $desc_he, $desc_ar,
        $features, $ing_he, $ing_ar,
        $mainImg, $gJson,
        $id
    ];
} else {
    /* -------- INSERT -------- */
    $sql = "INSERT INTO shop_products
              (title,title_he,title_ar,category,subcategory,
               description,description_he,description_ar,features,
               ingredients_he,ingredients_ar,images,gallery,status,date_added)
            VALUES
              (?,?,?,?,?,?,?,?,?,?,?,?,?,'publish',NOW())";
    $types  = 'sssssssssssss';
    $params = [
        $title, $title_he, $title_ar,
        $catID, $subID,
        $desc, $desc_he, $desc_ar,
        $features, $ing_he, $ing_ar,
        $mainImg, $gJson
    ];
}

$stmt = $conn->prepare($sql);
$bind = [&$types];
foreach ($params as &$p) $bind[] = &$p;
call_user_func_array([$stmt, 'bind_param'], $bind);
$stmt->execute();

$pid = $id ?: $conn->insert_id;

/*-------------------------------------------------
| 4)  per-unit prices
-------------------------------------------------*/
$conn->query("DELETE FROM shop_product_prices WHERE product_id = $pid");

if (!empty($_POST['weights'])) {
    $ins = $conn->prepare("INSERT INTO shop_product_prices
                             (product_id,weight,unit,price,barcode)
                           VALUES (?,?,?,?,?)");
    foreach ($_POST['weights'] as $i => $w) {
        if ($w === '' || !isset($_POST['units'][$i])) continue;
        $u  = $_POST['units'][$i]   ?? '';
        $pr = (float)($_POST['prices'][$i]  ?? 0);
        $bc = $_POST['barcodes'][$i]?? '';
        $ins->bind_param('idsds', $pid, $w, $u, $pr, $bc);
        $ins->execute();
    }
}

header('Location: my-products.php?msg=saved');
exit;



// ✅ Ensure image variants exist if we have a main image
try {
    if ($image_full) {
        $absDir = $_SERVER['DOCUMENT_ROOT'] . preg_replace('#/[^/]+$#','',$image_full);
        $relDir = preg_replace('#/[^/]+$#','',$image_full);
        $base   = basename($image_full);
        $v = imgutils_generate_variants($absDir, $relDir, $base, true);
        if ($v['ok']) {
            $image_226 = $v['thumb_226'];
            $image_tiny = $v['tiny_10'];
        }
    }
} catch (Throwable $e) { /* ignore */ }

// ✅ Persist the new metadata (if columns exist)
@$conn->query("UPDATE shop_products SET
    life_stage = " . ($life_stage ? ("'".$conn->real_escape_string($life_stage)."'") : "life_stage") . ",
    brand_id = " . (int)$brand_id . ",
    is_medical_food = " . (int)$is_medical_food . ",
    image_full = " . ($image_full ? ("'".$conn->real_escape_string($image_full)."'") : "image_full") . ",
    image_226  = " . ($image_226 ? ("'".$conn->real_escape_string($image_226)."'") : "image_226") . ",
    image_tiny = " . ($image_tiny ? ("'".$conn->real_escape_string($image_tiny)."'") : "image_tiny") . "
  WHERE id = ".(int)($id ?: $conn->insert_id)."
");
