<?php
include "./includes/Conn.php";
include "./includes/session.php";

/*--------------  EDIT-MODE --------------*/
$car = [];
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $stmt = $conn->prepare("SELECT * FROM cars_sale_inventory WHERE id=?");
    $stmt->bind_param("i", $_GET['id']);
    $stmt->execute();
    $car = $stmt->get_result()->fetch_assoc();
}

/*--------------  MASTER LISTS --------------*/
$makes = $conn->query("SELECT * FROM car_makes  ORDER BY make_name");
$models = $conn->query("SELECT * FROM car_models ORDER BY model_name");
?>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?= $car ? 'עריכת רכב' : 'הוספת רכב' ?></title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">

</head>

<body class="body">

    <!-- dashboard -->
    <div class="dashboard-overlay"></div>
    <?php include './includes/cms/aside.php'; ?>

    <div id="wrapper-dashboard">
        <div id="pagee" class="clearfix">

            <?php include './includes/cms/header.php'; ?>

        </div>

        <div id="themesflat-content">
            <div class="dashboard-toggle">Show DashBoard</div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-area">

                            <main class="container">
                                <h1><?= $car ? 'עריכת רכב' : 'הוספת רכב' ?></h1>

                                <form id="carForm" action="save_car.php" method="POST" enctype="multipart/form-data">
                                    <div class="row">
                                        <div class="col-lg-7">
                                            <div class="tfcl-add-listing car-details">
                                                <h3>פרטי הרכב
                                                </h3>

<!-- ①  HTML חדש  -->
<div class=" pill-form">        <!-- קיבל את הכיתה החדשה -->
    <label class="sr-only" for="titleInput">כותרת מודעה *</label>

    <input  type="text"
            id="titleInput"
            name="title"
            required
                 value="<?= $car['title'] ?? '' ?>"
            class="pill-input">          <!-- כיתה חדשה -->

    <button type="button"
            id="autoTitleBtn"
            class="pill-btn sc-button">   <!-- כיתה חדשה + הכיתה שלך -->
        צור אוטומטית
    </button>
</div>


                                                <div class="form-group-4">
                                                    <div class="form-group">
                                                        <label>יצרן*
                                                            <select name="make_id" id="make_id" class="form-control"
                                                                required>
                                                                <option value="">בחר יצרן</option>
                                                                <?php while ($m = $makes->fetch_assoc()): ?>
                                                                    <option value="<?= $m['id'] ?>" <?= ($car && $car['car_make'] == $m['id']) ? 'selected' : ''; ?>>
                                                                        <?= $m['make_name'] ?>
                                                                    </option>
                                                                <?php endwhile; ?>
                                                                <option value="__new">+ יצרן חדש…</option>
                                                            </select>
                                                        </label>
                                                    </div>

                                                    <div class="form-group">


                                                        <label>דגם*
                                                            <select name="model_id" id="model_id" class="form-control"
                                                                required>
                                                                <option value="">בחר דגם</option>
                                                                <?php while ($md = $models->fetch_assoc()): ?>
                                                                    <option value="<?= $md['id'] ?>" <?= ($car && $car['car_model'] == $md['id']) ? 'selected' : ''; ?>>
                                                                        <?= $md['model_name'] ?>
                                                                    </option>
                                                                <?php endwhile; ?>
                                                                <option value="__new">+ דגם חדש…</option>
                                                            </select>
                                                        </label>
                                                    </div>

                                                    <div class="form-group">

                                                        <label>שנת יצור*
                                                            <input type="number" name="manufacture_year" min="1900"
                                                                max="<?= date('Y') + 1 ?>" required
                                                                value="<?= $car['manufacture_year'] ?? '' ?>">
                                                        </label>
                                                    </div>

                                                    <div class="form-group">

                                                        <label>תאריך עלייה לכביש*
                                                            <input type="month" name="road_date" required value="<?php
                                                            if (!empty($car['road_date']))
                                                                echo date('Y-m', strtotime($car['road_date']));
                                                            ?>">
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="form-group-4">
                                                    <div class="form-group">
                                                        <label>יד*
                                                            <select name="hand" class="form-control" required>
                                                                <?php for ($i = 0; $i <= 5; $i++): ?>
                                                                    <option value="<?= $i ?>" <?= ($car && $car['hand'] == $i) ? 'selected' : ''; ?>><?= $i ?>
                                                                    </option>
                                                                <?php endfor; ?>
                                                            </select>
                                                        </label>
                                                    </div>

                                                    <div class="form-group">

                                                        <label>ק״מ
                                                            <input type="number" name="kilometers"
                                                                value="<?= $car['kilometers'] ?? $car['mileage'] ?? '' ?>">
                                                        </label>
                                                    </div>

                                                    <div class="form-group">
                                                        <label>kW
                                                            <input type="number" name="engine_power_kw" step="1"
                                                                value="<?= $car['engine_power_kw'] ?? '' ?>">
                                                        </label>
                                                    </div>

                                                    <div class="form-group">
                                                        <label>HP
                                                            <input type="number" name="horsepower" step="1"
                                                                value="<?= $car['horsepower'] ?? '' ?>">
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label>תיאור
                                                        <textarea
                                                            name="description"><?= $car['description'] ?? '' ?></textarea>
                                                    </label>
                                                </div>


                                                <div class="form-group-4">
                                                    <div class="form-group">
                                                        <label>מושבים
                                                            <input type="number" name="seating_capacity" min="1" max="9"
                                                                value="<?= $car['seating_capacity'] ?? '' ?>">
                                                        </label>
                                                    </div>

                                                    <div class="form-group">
<?php
// fetch all car-types
$carTypes = [];
$res = $conn->query("SELECT id, name FROM car_types ORDER BY id");
while ($row = $res->fetch_assoc()) {
    $carTypes[] = $row;
}

?>
                                                        <label>סוג רכב
  <select name="car_type_id" class="form-control" required>
    <option value="">– בחר –</option>
    <?php foreach ($carTypes as $ct): ?>
      <option value="<?= $ct['id'] ?>"
        <?= (isset($car['car_type_id']) && $car['car_type_id']==$ct['id']) ? 'selected' : '' ?>>
        <?= htmlspecialchars($ct['name']) ?>
      </option>
    <?php endforeach; ?>
  </select>
</label>


                                                        </label>
                                                    </div>

                                                    <div class="form-group">
                                                        <label style="display:flex;align-items:center;gap:6px">
                                                            <input type="checkbox" name="is_4x4" value="1" <?= ($car && $car['is_4x4']) ? 'checked' : ''; ?>>
                                                            4×4
                                                        </label>

                                                    </div>

                                                    <div class="form-group">
                                                        <label>תיבת הילוכים
                                                            <select class="form-control" name="transmission_type">
                                                                <?php foreach (['אוטומטי', 'ידני'] as $t): ?>
                                                                    <option <?= ($car && $car['transmission_type'] == $t) ? 'selected' : ''; ?>><?= $t ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="form-group-4">
                                                    <div class="form-group">
                                                        <label>סוג דלק
                                                            <select class="form-control" name="fuel_type">
                                                                <?php foreach (['בנזין', 'דיזל', 'חשמלי', 'היברידי'] as $f): ?>
                                                                    <option <?= ($car && $car['fuel_type'] == $f) ? 'selected' : ''; ?>><?= $f ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </label>
                                                    </div>

                                                    <div class="form-group">

                                                        <label>צבע <input type="text" name="color"
                                                                value="<?= $car['color'] ?? '' ?>"></label>

                                                    </div>

                                                    <div class="form-group">
                                                        <label>מחיר* <input type="number" name="price" required
                                                                value="<?= $car['price'] ?? '' ?>"></label>


                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-5">
                                            <div class="tfcl-add-listing car-details">
                                                <h3>מדיה
                                                </h3>
                                                <!-- ===== פאנל תמונות ===== -->
                                                <div class="row">
                                                    <div class="col-lg-5">

                                                        <h3>תמונה ראשית</h3>

                                                        <!-- שדה קישור – מוסתר, נשמר עבור PHP -->
                                                        <input type="hidden" name="main_img_url" id="mainImgUrl"
                                                            value="<?= htmlspecialchars($car['images'] ?? '') ?>">

                                                        <!-- כפתור העלאה -->
                                                        <label class="sc-button file-btn">
                                                            העלה קובץ
                                                            <input type="file" id="mainImgFile" name="main_image_file"
                                                                accept="image/*">
                                                        </label>
                                                    </div>
                                                    <div class="col-lg-7">

                                                        <!-- תצוגה חיה -->
                                                        <div id="mainImgPreview" class="main-preview">
                                                            <?php if (!empty($car['images'])): ?>
                                                                <img src="<?= htmlspecialchars($car['images']) ?>">
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- גלריות -->
                                                <div class="gallery-box">

                                                    <?php if (!empty($car['gallery'])):
                                                        $g = json_decode($car['gallery'], true); ?>
                                                        <h3>תמונות קיימות</h3>
                                                        <div class="gallery-wrap" id="oldGallery">
                                                            <?php foreach ($g as $img): ?>
                                                                <label class="thumb">
                                                                    <img src="<?= htmlspecialchars($img) ?>">
                                                                    <input type="hidden" value="<?= htmlspecialchars($img) ?>">
                                                                    <span class="remove" title="מחק">×</span>
                                                                </label>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    <?php endif; ?>

                                                    <h3 style="margin-top:24px">העלאת תמונות חדשות</h3>
                                                    <input type="file" name="images[]" id="galleryInput" multiple
                                                        accept="image/*">
                                                    <small>עד 10 תמונות, הראשונה תהיה תמונת-שער</small>

                                                    <div class="new-gallery-wrap" id="newGallery"></div>
                                                </div>


                                            </div>
                                        </div>
                                    </div>

                                    <!-- hidden -->
                                    <input type="hidden" name="car_id" value="<?= $car['id'] ?? '' ?>">
                                    <input type="hidden" name="old_images" value="<?= $car['images'] ?? '' ?>">
                                    <input type="hidden" name="old_gallery_json"
                                        value="<?= htmlspecialchars($car['gallery'] ?? '', ENT_QUOTES) ?>">
                                    <input type="hidden" name="gallery_sort_json" id="gallerySort">





                                    <div class="group-button-submit">
                                        <button name="save" class="pre-btn">שמור</button>
                                        <button name="save_preview" class="second-btn">שמור + תצוגה</button>
                                    </div>

                                </form>
                            </main>

                            <!-- ---------- MODAL ROOT (modalUtil) ---------- -->
                            <div id="storyModal" class="modal">
                                <div class="modal-box"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php include './includes/cms/modales.php'; ?>

    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>


    <!-- ===== SCRIPTS ===== -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.2/Sortable.min.js"
        crossorigin="anonymous"></script>

    <script src="app/js/modalUtil.js"></script> <!-- modalUtil root #storyModal קיים למעלה -->

    <script>
        /* ===== MAIN-IMAGE preview / URL fix ===== */
        $(function () {
            const $u = $('#mainImgUrl'), v = $u.val().trim();
            if (v && !/^[a-z][\w+.-]*:\/\//i.test(v))
                $u.val(location.origin + (v.startsWith('/') ? '' : '/') + v);
        });
        $('#mainImgFile').on('change', function () {
            const f = this.files[0]; if (!f) return;
            const r = new FileReader();
            r.onload = e => $('#mainImgPreview').html(`<img src="${e.target.result}">`);
            r.readAsDataURL(f);
            $('#mainImgUrl').val('');
        });
        $('#mainImgUrl').on('input', function () {
            $('#mainImgPreview').html(this.value.trim() ? `<img src="${this.value.trim()}">` : '');
        });

        /* ===== LIVE lists (ללא nice-select) ===== */
        let MAKES = [], MODELS = {};

        function renderMakes(sel) {
            const $m = $('#make_id');
            $m.find('option:not([value=""],[value="__new"])').remove();
            MAKES.forEach(m => $('<option>', { value: m.id, text: m.make_name })
                .insertBefore($m.find('[value="__new"]')));
            if (sel) $m.val(sel);
        }
        function renderModels(makeId, sel) {
            const $md = $('#model_id');
            $md.find('option:not([value=""],[value="__new"])').remove();
            (MODELS[makeId] || []).forEach(md => $('<option>', { value: md.id, text: md.model_name })
                .insertBefore($md.find('[value="__new"]')));
            if (sel) $md.val(sel);
        }
        function fetchLists(cb) {
            $.getJSON('ajax_cars.php', { action: 'make_model_lists' })
                .done(res => { MAKES = res.makes || []; MODELS = res.models || {}; cb && cb(); })
                .fail(() => modalUtil.alert('שגיאה בשליפת נתונים', 'error'));
        }
        fetchLists(() => {                        /* first paint */
            renderMakes(<?= (int) ($car['car_make'] ?? 0) ?>);
            renderModels($('#make_id').val(), <?= (int) ($car['car_model'] ?? 0) ?>);
        });
        $('#make_id').on('change', function () { if (this.value !== '__new') renderModels(this.value); });

        /* ===== “+ חדש” – פתיחת מודאל ===== */
        $('select').on('change', function () {
            if (this.value !== '__new') return;
            const isMake = this.id === 'make_id';
            modalUtil.open({
                title: isMake ? 'הוסף יצרן חדש' : 'הוסף דגם חדש',
                body: '<input id="newOptionValue" class="form-control" style="width:100%">',
                buttons: [
                    { text: 'ביטול', class: 'btn-cancel' },
                    { text: 'שמור', class: 'btn-ok', callback: () => saveNewOption(isMake) }
                ]
            });
            $(this).val('');               /* reset הבחירה */
        });
        function saveNewOption(isMake) {
            const name = $('#newOptionValue').val().trim();
            if (!name) return modalUtil.alert('נא למלא שם', 'error');

            const payload = isMake ? { action: 'add_make', name }
                : { action: 'add_model', make_id: $('#make_id').val(), name };

            /* dataType:'json' => מקבלים אובייקט, לא צריך JSON.parse */
            $.ajax({
                url: 'ajax_cars.php', method: 'POST', data: payload, dataType: 'json'
            }).done(res => {
                if (!res.ok) return modalUtil.alert(res.msg || 'שגיאה', 'error');

                fetchLists(() => {
                    if (isMake) { renderMakes(res.id); renderModels(res.id); }
                    else { renderModels($('#make_id').val(), res.id); }
                    modalUtil.alert('נשמר בהצלחה!', 'success').then(() => modalUtil.close());
                });
            }).fail(() => modalUtil.alert('שגיאת תקשורת', 'error'));
        }

        /* ===== גלריה קיימת – סימון למחיקה ===== */
        $(document).on('click', '.thumb .remove', function () {
            const img = $(this).prev('input').val();
            $('<input>', { type: 'hidden', name: 'delete_images[]', value: img }).appendTo('#carForm');
            $(this).closest('.thumb').remove();
        });

        /* ===== תצוגה מוקדמת + הסרה לקבצים חדשים ===== */
        $('#galleryInput').on('change', function () {
            const $wrap = $('#newGallery').empty(), files = [...this.files];
            files.forEach((f, i) => {
                const r = new FileReader();
                r.onload = e => {
                    const $t = $(`<label class="thumb">
                       <img src="${e.target.result}">
                       <span class="remove" title="מחק">×</span>
                    </label>`).appendTo($wrap);
                    $t.find('.remove').click(() => {
                        /* מעדכנים את FileList באמצעות DataTransfer */
                        const dt = new DataTransfer();
                        files.forEach((ff, idx) => { if (idx !== i) dt.items.add(ff); });
                        $('#galleryInput')[0].files = dt.files;
                        $t.remove(); updateOrder();
                    });
                };
                r.readAsDataURL(f);
            });
        });

        /* ===== Sortable (RTL) + שמירת סדר ===== */
        ['oldGallery', 'newGallery'].forEach(id => {
            const el = document.getElementById(id);
            if (el) new Sortable(el, { animation: 150, onSort: updateOrder });
        });
        function updateOrder() {
            const all = $('#oldGallery .thumb img, #newGallery .thumb img')
                .map((i, im) => $(im).attr('src')).get();
            $('#gallerySort').val(JSON.stringify(all));
        }
        $('#carForm').on('submit', updateOrder);
        $('#autoTitleBtn').on('click', function () {

    const makeTxt  = $('#make_id option:selected').text().trim();
    const modelTxt = $('#model_id option:selected').text().trim();
    const year     = $('input[name="manufacture_year"]').val().trim();
    const hand     = $('select[name="hand"]').val().toString().padStart(2,'0');

    if (!makeTxt || !modelTxt || !year || !hand) {
        alert('חובה לבחור יצרן, דגם, שנה ויד');
        return;
    }

    // דוגמה: "אודי A8 לונג יד 02"
    const auto = `${makeTxt} ${modelTxt} יד ${hand} ${year}`;
    $('#titleInput').val(auto);
});

    </script>
</body>

</html>