<?php
require './includes/Conn.php';
header('Content-Type: application/json; charset=utf-8');

$action = $_REQUEST['action'] ?? '';
$out    = ['ok' => false, 'msg' => 'unknown action'];

/*-------------------------------------------------
|  1)  makers / models select-lists (edit-form)
|      GET  ajax_cars.php?action=make_model_lists
-------------------------------------------------*/
if ($action === 'make_model_lists') {
    $makes = $conn->query("SELECT id,make_name FROM car_makes ORDER BY make_name")
                  ->fetch_all(MYSQLI_ASSOC);

    $res   = $conn->query(
             "SELECT id,make_id,model_name FROM car_models ORDER BY model_name");
    $models = [];
    while ($m = $res->fetch_assoc()) $models[$m['make_id']][] = $m;

    echo json_encode(['makes' => $makes, 'models' => $models]);
    exit;
}

/*-------------------------------------------------
|  2)  add a new make
|      POST ajax_cars.php?action=add_make&name=xxx
-------------------------------------------------*/
if ($action === 'add_make') {
    $name = trim($_POST['name'] ?? '');
    if ($name === '') { $out['msg'] = 'חסר שם יצרן';  echo json_encode($out); exit; }

    /* avoid duplicates */
    $q = $conn->prepare("SELECT id FROM car_makes WHERE make_name=?");
    $q->bind_param('s', $name); $q->execute(); $q = $q->get_result();
    if ($q->num_rows) { echo json_encode(['ok'=>true,'id'=>$q->fetch_assoc()['id']]); exit; }

    $q = $conn->prepare("INSERT INTO car_makes(make_name) VALUES(?)");
    $q->bind_param('s', $name);
    $out['ok'] = $q->execute();
    $out['id'] = $conn->insert_id;
    $out['msg']= $out['ok'] ? 'נוסף' : 'שגיאה';
    echo json_encode($out); exit;
}

/*-------------------------------------------------
|  3)  add a new model  (needs make_id + name)
|      POST ajax_cars.php?action=add_model&make_id=3&name=Foo
-------------------------------------------------*/
if ($action === 'add_model') {
    $make_id = (int)($_POST['make_id'] ?? 0);
    $name    = trim($_POST['name']   ?? '');
    if (!$make_id || $name===''){ $out['msg']='חסר דגם / יצרן'; echo json_encode($out); exit; }

    /* duplicate guard */
    $q = $conn->prepare("SELECT id FROM car_models WHERE make_id=? AND model_name=?");
    $q->bind_param('is', $make_id, $name); $q->execute(); $q = $q->get_result();
    if ($q->num_rows){ echo json_encode(['ok'=>true,'id'=>$q->fetch_assoc()['id']]); exit; }

    $q = $conn->prepare("INSERT INTO car_models(make_id,model_name) VALUES(?,?)");
    $q->bind_param('is', $make_id, $name);
    $out['ok']=$q->execute();
    $out['id']=$conn->insert_id;
    $out['msg']=$out['ok']?'נוסף':'שגיאה';
    echo json_encode($out); exit;
}

/*-------------------------------------------------
|  4-N)  … everything else you already had …
|        keep your list / get / save / delete etc.
-------------------------------------------------*/

/* fall-through if nothing matched */
echo json_encode($out);
