<?php
declare(strict_types=1);
include '../includes/Conn.php';
include '../includes/cms/session.php';
require_once '../includes/image_utils.php';
header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? $_GET['action'] ?? '';
$relDir = '/uploads/products';
$absDir = $_SERVER['DOCUMENT_ROOT'].$relDir;
if (!is_dir($absDir)) @mkdir($absDir, 0775, true);

function normalize_path_from_src(string $src): string {
    // Accept absolute URLs or relative paths; return a path starting with "/"
    $src = trim($src);
    if ($src === '') return '';
    if (preg_match('~^https?://~i', $src)) {
        $p = parse_url($src, PHP_URL_PATH);
        return $p ?: '';
    }
    $src = preg_replace('~\?.*$~', '', $src);     // strip query
    $src = preg_replace('~^\.?/~', '', $src);     // drop leading "./" or "/"
    return '/'.$src;
}

$out = ['ok'=>false,'msg'=>'Unknown action'];
try {
    switch ($action) {
        case 'upload':
            $r = imgutils_save_upload($_FILES['file'] ?? [], $absDir, $relDir);
            if (!$r['ok']) throw new Exception($r['msg'] ?? 'upload failed');
            $base = basename($r['rel']);
            $v    = imgutils_generate_variants($absDir,$relDir,$base,true);
            $out  = ['ok'=>true, 'src'=>$r['rel'], 'thumb_226'=>$v['thumb_226'], 'tiny_10'=>$v['tiny_10']];
            break;

        case 'crop':
            $src = normalize_path_from_src($_POST['src'] ?? '');
            $x = isset($_POST['x']) ? (int)round((float)$_POST['x']) : 0;
            $y = isset($_POST['y']) ? (int)round((float)$_POST['y']) : 0;
            $w = isset($_POST['w']) ? (int)max(1, round((float)$_POST['w'])) : 0;
            $h = isset($_POST['h']) ? (int)max(1, round((float)$_POST['h'])) : 0;
            if (!$src || !$w || !$h) throw new Exception('Bad crop');
            $srcAbs = $_SERVER['DOCUMENT_ROOT'].$src;
            if (!is_file($srcAbs)) throw new Exception('Source not found');
            $ext = strtolower(pathinfo($src, PATHINFO_EXTENSION));
            if (!$ext) $ext = 'jpg';
            $nameNoExt = preg_replace('/\.[^.]+$/','', basename($src));
            $dstAbs = $absDir.'/'.$nameNoExt.'_CROP.'.$ext;
            $r = imgutils_crop($srcAbs,$dstAbs,$x,$y,$w,$h);
            if (!$r['ok']) throw new Exception($r['msg'] ?? 'crop failed');
            $rel = $relDir.'/'.basename($dstAbs);
            $v   = imgutils_generate_variants($absDir,$relDir,basename($dstAbs),true);
            $out = ['ok'=>true,'src'=>$rel,'thumb_226'=>$v['thumb_226'],'tiny_10'=>$v['tiny_10']];
            break;

        case 'pad_to_square':
            $src = normalize_path_from_src($_POST['src'] ?? '');
            if (!$src) throw new Exception('No src');
            $srcAbs = $_SERVER['DOCUMENT_ROOT'].$src;
            if (!is_file($srcAbs)) throw new Exception('Source not found');
            $ext    = strtolower(pathinfo($src, PATHINFO_EXTENSION));
            if (!$ext) $ext = 'jpg';
            $nameNoExt = preg_replace('/\.[^.]+$/','', basename($src));
            $dstAbs = $absDir.'/'.$nameNoExt.'_SQUARE.'.$ext;
            $r = imgutils_pad_to_square($srcAbs,$dstAbs,'#FFFFFF');
            if (!$r['ok']) throw new Exception($r['msg'] ?? 'pad failed');
            $rel = $relDir.'/'.basename($dstAbs);
            $v   = imgutils_generate_variants($absDir,$relDir,basename($dstAbs),false);
            $out = ['ok'=>true,'src'=>$rel,'thumb_226'=>$v['thumb_226'],'tiny_10'=>$v['tiny_10']];
            break;

        case 'variants':
            $src = normalize_path_from_src($_POST['src'] ?? '');
            if (!$src) throw new Exception('No src');
            $v = imgutils_generate_variants($absDir,$relDir,basename($src),true);
            $out = array_merge(['ok'=>true], $v);
            break;

        default:
            $out = ['ok'=>false,'msg'=>'Unknown action'];
    }
} catch (Throwable $e) { $out = ['ok'=>false,'msg'=>$e->getMessage()]; }
echo json_encode($out, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
