<?php
require './includes/Conn.php';
header('Content-Type: application/json; charset=utf-8');

$action = $_REQUEST['action']??'';
$out    = ['ok'=>false,'msg'=>''];

switch($action){

/* 🔄 רשימות יצרנים/דגמים לטפסים ---------------------------- */
case 'make_model_lists':
    $makes   = $conn->query("SELECT id,make_name FROM car_makes ORDER BY make_name")->fetch_all(MYSQLI_ASSOC);
    $modelsQ = $conn->query("SELECT id,make_id,model_name FROM car_models ORDER BY model_name");
    $models  = [];
    while($m=$modelsQ->fetch_assoc()) $models[$m['make_id']][]=$m;
    echo json_encode(['makes'=>$makes,'models'=>$models]); exit;

/* 📄 טעינת מודעות (pagination) ------------------------------ */
case 'list':
    $uid  = 1;                      /* ←– זהות המשתמש הלוגד-אין */
    $page = (int)($_GET['page']??0);
    $lim  = (int)($_GET['limit']??10);
    $off  = $page*$lim;
    $rows = $conn->query("
        SELECT c.id,c.title,c.price,c.manufacture_year   AS year,
               m.make_name AS make,md.model_name AS model,
               c.sold,c.delivery_disabled
        FROM cars c
        JOIN car_makes  m  ON m.id = c.make_id
        JOIN car_models md ON md.id = c.model_id
        WHERE c.user_id=$uid
        ORDER BY c.id DESC
        LIMIT $off,$lim+1");
    $data = $rows->fetch_all(MYSQLI_ASSOC);
    $hasMore=count($data)>$lim;
    if($hasMore)array_pop($data);
    echo json_encode(['data'=>$data,'hasMore'=>$hasMore]); exit;

/* 📋 פרטי מודעה אחת ---------------------------------------- */
case 'get':
    $id=(int)($_GET['id']??0);
    $q =$conn->query("SELECT * FROM cars WHERE id=$id");
    echo json_encode($q->fetch_assoc()); exit;

/* 💾 יצירה/עדכון ------------------------------------------- */
case 'save':
    $uid =1;        // מזהה משתמש
    $id  =(int)($_POST['car_id']??0);
    $fields=['title','make_id','model_id','manufacture_year','condition',
             'mileage','transmission_type','fuel_type','color','description','price'];
    $vals=[];
    foreach($fields as $f) $vals[$f]=trim($_POST[$f]??'');
    if(!$vals['title']||!$vals['make_id']||!$vals['model_id']||!$vals['manufacture_year']){
        $out['msg']='שדות חובה חסרים'; break;
    }
    if($id){   /* update */
        $set = implode(',', array_map(fn($k)=>"$k=?",array_keys($vals)));
        $stmt=$conn->prepare("UPDATE cars SET $set WHERE id=? AND user_id=?");
        $stmt->bind_param(str_repeat('s',count($vals)).'ii',...array_values($vals),$id,$uid);
        $out['ok']=$stmt->execute();
        $out['msg']=$out['ok']?'עודכן':'שגיאה';
    }else{     /* insert */
        $cols=implode(',',array_keys($vals));
        $ph = implode(',',array_fill(0,count($vals),'?'));
        $stmt=$conn->prepare("INSERT INTO cars($cols,user_id) VALUES($ph,?)");
        $stmt->bind_param(str_repeat('s',count($vals)).'i',...array_values($vals),$uid);
        $out['ok']=$stmt->execute();
        $out['msg']=$out['ok']?'נוצר':'שגיאה';
        $id=$conn->insert_id;
    }
    /* תמונות: שמירה בסיסית */
    if($out['ok'] && !empty($_FILES['images']['name'][0])){
        $uploadDir='uploads/cars/'.$id.'/';
        if(!is_dir($uploadDir))mkdir($uploadDir,0777,true);
        foreach($_FILES['images']['tmp_name'] as $i=>$tmp){
            move_uploaded_file($tmp,$uploadDir.basename($_FILES['images']['name'][$i]));
        }
    }
    echo json_encode($out); exit;

/* ✅ סמן כנמכר --------------------------------------------- */
case 'mark_sold':
    $id=(int)$_POST['id']; $conn->query("UPDATE cars SET sold=1 WHERE id=$id"); exit;

/* 🚚 Toggle delivery --------------------------------------- */
case 'toggle_delivery':
    $id=(int)$_POST['id']; $conn->query("UPDATE cars SET delivery_disabled=1-delivery_disabled WHERE id=$id"); exit;

/* ❌ delete ------------------------------------------------ */
case 'delete':
    $id=(int)$_POST['id']; $conn->query("DELETE FROM cars WHERE id=$id"); exit;

/* 📲 נתוני וואטסאפ ---------------------------------------- */
case 'wa_info':
    $id=(int)$_GET['id'];
    $c=$conn->query("
         SELECT c.title,m.make_name AS make,md.model_name AS model,
                c.manufacture_year AS year,c.price
         FROM cars c
         JOIN car_makes m  ON m.id=c.make_id
         JOIN car_models md ON md.id=c.model_id
         WHERE c.id=$id")->fetch_assoc();
    $c['url']= 'https://'.$_SERVER['HTTP_HOST'].'/listing.php?id='.$id;
    echo json_encode($c); exit;
}
echo json_encode($out);
