<?php
require './includes/Conn.php';
header('Content-Type: application/json; charset=utf-8');

$action = $_REQUEST['action'] ?? '';
$out    = ['ok'=>false,'msg'=>'פעולה לא מזוהה'];

/* כלי עזר */
function already_exists(mysqli $c,string $sql,array $p):bool{
    $stmt=$c->prepare($sql);
    $stmt->bind_param(str_repeat('s',count($p)),...$p);
    $stmt->execute(); $stmt->store_result();
    return $stmt->num_rows>0;
}

/* ---------- list ---------- */
if($action==='list'){
    $rs=$conn->query("SELECT m.id,m.make_name,
                             COALESCE(GROUP_CONCAT(md.model_name ORDER BY md.model_name SEPARATOR ', '),'-') AS models
                      FROM car_makes m
                      LEFT JOIN car_models md ON md.make_id=m.id
                      GROUP BY m.id ORDER BY m.make_name");
    echo json_encode($rs->fetch_all(MYSQLI_ASSOC)); exit;
}

/* ---------- get single make (id) ---------- */
if($action==='get_make'){
    $id=(int)($_GET['id']??0);
    $res=$conn->query("SELECT make_name FROM car_makes WHERE id=$id LIMIT 1");
    if(!$res->num_rows){ echo 'null'; exit; }
    $make=$res->fetch_assoc();
    $models=$conn->query("SELECT model_name FROM car_models WHERE make_id=$id ORDER BY model_name")
                 ->fetch_all(MYSQLI_ASSOC);
    echo json_encode([
        'id'        =>$id,
        'make_name' =>$make['make_name'],
        'models'    =>array_column($models,'model_name')
    ]);
    exit;
}

/* ---------- add make ---------- */
if($action==='add_make'){
    $name=trim($_POST['make_name']??'');
    if($name===''){ $out['msg']='שם חסר'; }
    elseif(already_exists($conn,"SELECT id FROM car_makes WHERE make_name=?",[$name])){
        $out['msg']='יצרן קיים כבר';
    }else{
        $stmt=$conn->prepare("INSERT INTO car_makes(make_name) VALUES(?)");
        $stmt->bind_param('s',$name); $out['ok']=$stmt->execute();
        $out['msg']=$out['ok']?'היצרן נוסף':'שגיאת DB';
    }
}

/* ---------- add model ---------- */
elseif($action==='add_model'){
    $make=(int)($_POST['make_id']??0);
    $model=trim($_POST['model_name']??'');
    if(!$make||$model===''){ $out['msg']='שדות חסרים'; }
    elseif(already_exists($conn,
          "SELECT id FROM car_models WHERE make_id=? AND model_name=?",[$make,$model])){
          $out['msg']='דגם זה כבר קיים ליצרן';
    }else{
        $stmt=$conn->prepare("INSERT INTO car_models(make_id,model_name) VALUES(?,?)");
        $stmt->bind_param('is',$make,$model); $out['ok']=$stmt->execute();
        $out['msg']=$out['ok']?'הדגם נוסף':'שגיאת DB';
    }
}

/* ---------- save make & models (עריכה) ---------- */
elseif($action==='save_make'){         /* id, make_name, models (CSV) */
    $id  =(int)($_POST['id']??0);
    $name=trim($_POST['make_name']??'');
    $csv =trim($_POST['models']??'');
    $newModels=array_filter(array_map('trim',explode(',',$csv)));

    if($name===''){ $out['msg']='שם חסר'; echo json_encode($out); exit; }

    if(already_exists($conn,
        "SELECT id FROM car_makes WHERE make_name=? AND id<>?",[$name,$id])){
        $out['msg']='שם יצרן קיים כבר'; echo json_encode($out); exit;
    }

    /* טרנזקציה מלאה */
    $conn->begin_transaction();
    $ok1=$conn->prepare("UPDATE car_makes SET make_name=? WHERE id=?")
              ->bind_param('si',$name,$id) || true;  // dummy to keep scope

    $stmt=$conn->prepare("UPDATE car_makes SET make_name=? WHERE id=?");
    $stmt->bind_param('si',$name,$id); $ok1=$stmt->execute();

    /* רשימת דגמים נוכחיים */
    $curRows=$conn->query("SELECT id,model_name FROM car_models WHERE make_id=$id")
                  ->fetch_all(MYSQLI_ASSOC);
    $current=array_column($curRows,'model_name','id');

    /* הפרדה להוספה / מחיקה */
    $toDelete=array_diff($current,$newModels);            // by value
    $toAdd   =array_diff($newModels,$current);

    /* מחיקה */
    if($toDelete){
        $ids=array_keys(array_intersect($current,$toDelete));  // ids to delete
        $conn->query("DELETE FROM car_models WHERE id IN(".implode(',',$ids).")");
    }
    /* הוספה */
    if($toAdd){
        $stmtIns=$conn->prepare("INSERT INTO car_models(make_id,model_name) VALUES(?,?)");
        foreach($toAdd as $mdl){
            $stmtIns->bind_param('is',$id,$mdl);
            $stmtIns->execute();
        }
    }

    if($ok1) { $conn->commit();  $out=['ok'=>true,'msg'=>'עודכן בהצלחה']; }
    else     { $conn->rollback();$out['msg']='שגיאת DB'; }
}

/* ---------- delete make (with models) ---------- */
elseif($action==='delete_make'){
    $id=(int)($_POST['id']??0);
    $conn->begin_transaction();
    $conn->query("DELETE FROM car_models WHERE make_id=$id");
    $res=$conn->query("DELETE FROM car_makes WHERE id=$id");
    if($res){ $conn->commit();  $out=['ok'=>true,'msg'=>'נמחק בהצלחה']; }
    else     { $conn->rollback();$out['msg']='שגיאת DB'; }
}

echo json_encode($out);
