
<?php
header('Content-Type: application/json; charset=utf-8');
include './includes/Conn.php';
try {
  $id = isset($_POST['id']) && is_numeric($_POST['id']) ? (int)$_POST['id'] : 0;
  if(!$id) throw new Exception('מזהה לא חוקי');
  $stmt = $conn->prepare("UPDATE cars_sale_inventory SET status='sold' WHERE id = ?");
  if(!$stmt) throw new Exception('שגיאה בהכנת השאילתה: ' . $conn->error);
  $stmt->bind_param('i', $id);
  if(!$stmt->execute()) throw new Exception('שגיאה בעדכון הסטאטוס: ' . $stmt->error);
  echo json_encode(['success' => true]);
} catch(Exception $e) {
  http_response_code(400);
  echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
