<?php
// car-box.php - Reusable Car Box Component
// car-box.php - Reusable Car Box Component
function renderCarBox($car, $style = 'default', $type = '') {
    global $static_files_domain;
    $main_image = !empty($car['images']) ? $car['images'] : 'assets/images/default-car.jpg';
    $kms_display = $car['kilometers'] == 0 ? '0 ק"מ' : number_format($car['kilometers'] / 1000, 0) . 'k ק"מ';
    
    ?>

<div class="box-car-list <?= $style ?> hv-one">                          <div class="image-group relative">
                            <div class="top flex-two">
                              <ul class="d-flex gap-8">
                                <?php if ($car['kilometers'] == 0): ?>
                                  <li class="flag-tag warning"><?=$kms_display ?></li>
                                <?php endif; ?>
                                <li class="flag-tag style-1">
                                  <div class="icon">
                                    <svg width="16" height="13" viewBox="0 0 16 13" fill="none"
                                      xmlns="http://www.w3.org/2000/svg">
                                      <path
                                        d="M1.5 9L4.93933 5.56067C5.07862 5.42138 5.24398 5.31089 5.42597 5.2355C5.60796 5.16012 5.80302 5.12132 6 5.12132C6.19698 5.12132 6.39204 5.16012 6.57403 5.2355C6.75602 5.31089 6.92138 5.42138 7.06067 5.56067L10.5 9M9.5 8L10.4393 7.06067C10.5786 6.92138 10.744 6.81089 10.926 6.7355C11.108 6.66012 11.303 6.62132 11.5 6.62132C11.697 6.62132 11.892 6.66012 12.074 6.7355C12.256 6.81089 12.4214 6.92138 12.5607 7.06067L14.5 9M2.5 11.5H13.5C13.7652 11.5 14.0196 11.3946 14.2071 11.2071C14.3946 11.0196 14.5 10.7652 14.5 10.5V2.5C14.5 2.23478 14.3946 1.98043 14.2071 1.79289C14.0196 1.60536 13.7652 1.5 13.5 1.5H2.5C2.23478 1.5 1.98043 1.60536 1.79289 1.79289C1.60536 1.98043 1.5 2.23478 1.5 2.5V10.5C1.5 10.7652 1.60536 11.0196 1.79289 11.2071C1.98043 11.3946 2.23478 11.5 2.5 11.5Z"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                      </path>
                                    </svg>
                                  </div>
                                  <?php echo (int) $car['seating_capacity']; ?>
                                </li>
                              </ul>
                              <div class="year flag-tag"><?php echo htmlspecialchars($car['manufacture_year']); ?></div>
                            </div>
                            <a href="/car/<?php echo $car['id']; ?>" style="display:block">
                            <div class="img-style">
                                 <img src="<?php echo $static_files_domain .  htmlspecialchars(str_replace("http://tan.localhost","",$main_image)) ?>" alt="car">
                            </div>
                            </a>
                          </div>

                          <div class="content">
                            <div class="text-address">
                              <p class="text-color-3 font"> <?php echo htmlspecialchars($type); ?></p>
                            </div>
                            <h5 class="link-style-1">
                              <a href="/car/<?php echo $car['id']; ?>">
                                <?php echo htmlspecialchars($car['title'] ) ?>
                              </a>
                            </h5>
                            <div class="icon-box flex flex-wrap">
                              <div class="icons flex-three"><i
                                  class="icon-autodeal-km1"></i><span><?php echo $kms_display; ?></span></div>
                              <div class="icons flex-three"><i
                                  class="icon-autodeal-diesel"></i><span><?php echo htmlspecialchars($car['fuel_type']); ?></span>
                              </div>
                              <div class="icons flex-three"><i
                                  class="icon-autodeal-automatic"></i><span><?php echo htmlspecialchars($car['transmission_type']); ?></span>
                              </div>
                            </div>
                            <div class="money fs-20 fw-5 lh-25 text-color-3">₪<span><?php echo number_format($car['price'], 0); ?></span>
                            </div>
                            <div class="days-box flex justify-end align-center">

                              <a href="/car/<?php echo $car['id']; ?>" class="view-car">פרטים נוספים 
<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="24" height="24" fill="white"/>
<path d="M14.5 17L9.5 12L14.5 7" stroke="#000000" stroke-linecap="round" stroke-linejoin="round"/>
</svg></a>
                              
                            </div>
                          </div>
                      </div>
<?php } ?>
