<?php
// ✅ Defined static price ranges
$price_ranges = [
    'כל הרכבים' => [0, PHP_INT_MAX],
    '₪100K - ₪200K' => [100000, 200000],
    '₪200K - ₪500K' => [200000, 500000],
    'מעל ₪500K' => [500000, PHP_INT_MAX]
];

$per_page = 4;
$current_tab = isset($_GET['tab']) ? (int) $_GET['tab'] : 0;
$current_page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$offset = ($current_page - 1) * $per_page;
?>

<section class="tf-section3">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="heading-section flex align-center justify-space flex-wrap gap-20">
                    <h2 class="wow fadeInUpSmall" data-wow-delay="0.2s" data-wow-duration="1000ms">
                        רכב לפי תקציב
                    </h2>
                    <a href="car-list.php" class="tf-btn-arrow wow fadeInUpSmall" data-wow-delay="0.2s"
                        data-wow-duration="1000ms">
                        הצג את הכל<i class="icon-autodeal-btn-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="flat-tabs themesflat-tabs">
                    <div class="box-tab center">
                        <ul class="menu-tab tab-title style flex">
                            <?php $tabIndex = 0;
                            foreach ($price_ranges as $label => $range): ?>
                                <li class="item-title <?php echo $tabIndex === $current_tab ? 'active' : ''; ?>">
                                <li class="item-title <?php echo $index === 0 ? 'active' : ''; ?>">
                                    <h5 class="inner"><?php echo $label; ?></h5>
                                </li>
                                </li>
                                <?php $tabIndex++; endforeach; ?>
                        </ul>
                        </ul>
                    </div>

                    <div class="content-tab">
                        <?php
                        $tabIndex = 0;
                        foreach ($price_ranges as $label => $range):
                            if ($tabIndex !== $current_tab) {
                                $tabIndex++;
                                continue;
                            }

                            [$min_price, $max_price] = $range;

                            $condition = "kilometers > 0 AND price >= ? AND price < ?";
                            if ($tabIndex === 0) {
                                $condition = "kilometers > 0";
                            }

                            $count_sql = "SELECT COUNT(*) as total FROM cars_sale_inventory WHERE {$condition}";
                            $stmt = $conn->prepare($count_sql);
                            if ($tabIndex > 0) {
                                $stmt->bind_param("ii", $min_price, $max_price);
                            }
                            $stmt->execute();
                            $total_result = $stmt->get_result()->fetch_assoc();
                            $total_pages = ceil($total_result['total'] / $per_page);

                            $sql = "SELECT c.*, m.make_name, cm.model_name 
                            FROM cars_sale_inventory c
                            LEFT JOIN car_makes m ON c.car_make = m.id
                            LEFT JOIN car_models cm ON c.car_model = cm.id
                            WHERE {$condition}
                            ORDER BY c.price ASC
                            LIMIT ? OFFSET ?";

                            $stmt = $conn->prepare($sql);
                            if ($tabIndex > 0) {
                                $stmt->bind_param("iiii", $min_price, $max_price, $per_page, $offset);
                            } else {
                                $stmt->bind_param("ii", $per_page, $offset);
                            }

                            $stmt->execute();
                            $result = $stmt->get_result();
                            ?>
                            <div class="content-inner tab-content <?php echo $i === 0 ? 'active' : ''; ?>">
                                <div class="list-car-grid-2">
                                    <?php while ($car = $result->fetch_assoc()):
                                        $main_image = !empty($car['images']) ? $car['images'] : 'assets/images/default-car.jpg';
                                        $kms_display = $car['kilometers'] == 0 ? '0 ק"מ' : number_format($car['kilometers'] / 1000, 0) . 'k ק"מ';
                                        ?>
                                        <div class="box-car-list style-2 style-dark hv-one">
                                            <div class="image-group relative">
                                                <div class="top flex-two">
                                                    <ul class="d-flex gap-8">
                                                        <?php if ($car['kilometers'] == 0): ?>
                                                            <li class="flag-tag success">Featured</li>
                                                        <?php endif; ?>
                                                        <li class="flag-tag style-1">
                                                            <div class="icon">
                                                                <i class="icon-autodeal-seat"></i>
                                                            </div>
                                                            <?php echo (int) $car['seating_capacity']; ?>
                                                        </li>
                                                    </ul>
                                                    <div class="year flag-tag">
                                                        <?php echo $car['manufacture_year']; ?>
                                                    </div>
                                                </div>
                                                <div class="img-style">
                                                    <img src="<?php echo htmlspecialchars($main_image); ?>" alt="Car Image">
                                                </div>
                                            </div>

                                            <div class="content">
                                                 <div class="text-address">
                              <p class="text-color-3 font"> <?php echo htmlspecialchars($type); ?></p>
                            </div>
                                                <h5 class="link-style-1">
                                                    <a href="car-list.php?id=<?php echo $car['id']; ?>">
                                                        <?php echo htmlspecialchars($car['title']) ?>
                                                    </a>
                                                    
                                                </h5>
                                                <div class="icon-box flex flex-wrap">
                                                    <div class="icons flex-three"><i
                                                            class="icon-autodeal-km1"></i><span><?php echo $kms_display; ?></span>
                                                    </div>
                                                    <div class="icons flex-three"><i
                                                            class="icon-autodeal-diesel"></i><span><?php echo htmlspecialchars($car['fuel_type']); ?></span>
                                                    </div>
                                                    <div class="icons flex-three"><i
                                                            class="icon-autodeal-automatic"></i><span><?php echo htmlspecialchars($car['transmission_type']); ?></span>
                                                    </div>
                                                </div>
                                                <div class="money fs-20 fw-5 lh-25 text-color-3 money_di">
                                                    ₪<?php echo number_format($car['price'], 0); ?>
                                                </div>
                                                <div class="days-box flex justify-end align-center">

                              <a href="car-list.php?id=<?php echo $car['id']; ?>" class="view-car">פרטים נוספים</a>
                            </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                            <?php break; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
</section>