<?php
// includes/cms/StaticPage.php

class StaticPage {
    private mysqli $conn;

    public int $id;
    public string $title;
    public string $slug;
    public string $content;
    public ?string $image_path;
    public bool $is_active;
    public bool $show_in_menu;
    public bool $show_in_footer;
    public string $created_at;
    public string $updated_at;

    public function __construct(mysqli $conn) {
        $this->conn = $conn;
    }

    /** מחזיר את כל הדפים בסדר יורד לפי תאריך יצירה */
    public function findAll(): array {
        $res = $this->conn->query("SELECT * FROM static_pages ORDER BY created_at DESC");
        $pages = [];
        while ($row = $res->fetch_assoc()) {
            $page = new self($this->conn);
            foreach ($row as $k => $v) {
                $page->$k = $v;
            }
            $pages[] = $page;
        }
        return $pages;
    }

    /** מוצא דף לפי ID */
    public function findById(int $id): ?self {
        $stmt = $this->conn->prepare("SELECT * FROM static_pages WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($row = $res->fetch_assoc()) {
            $page = new self($this->conn);
            foreach ($row as $k => $v) {
                $page->$k = $v;
            }
            return $page;
        }
        return null;
    }

    /** יוצר או מעדכן דף */
    public function save(): bool {
        if (!empty($this->id)) {
            // update
            $stmt = $this->conn->prepare(
                "UPDATE static_pages SET
                   title=?, slug=?, content=?, image_path=?, is_active=?, show_in_menu=?, show_in_footer=?
                 WHERE id=?"
            );
            // 4 strings (title, slug, content, image_path) and 3 ints + id int
            $stmt->bind_param(
                "sssssiii",
                $this->title,
                $this->slug,
                $this->content,
                $this->image_path,
                $this->is_active,
                $this->show_in_menu,
                $this->show_in_footer,
                $this->id
            );
        } else {
            // insert
            $stmt = $this->conn->prepare(
                "INSERT INTO static_pages
                   (title, slug, content, image_path, is_active, show_in_menu, show_in_footer)
                 VALUES (?,?,?,?,?,?,?)"
            );
            // 4 strings and 3 ints
            $stmt->bind_param(
                "ssssiii",
                $this->title,
                $this->slug,
                $this->content,
                $this->image_path,
                $this->is_active,
                $this->show_in_menu,
                $this->show_in_footer
            );
        }

        $ok = $stmt->execute();
        if ($ok && empty($this->id)) {
            $this->id = $this->conn->insert_id;
        }
        return $ok;
    }

    /** מוחק דף */
    public function delete(): bool {
        if (empty($this->id)) {
            return false;
        }
        $stmt = $this->conn->prepare("DELETE FROM static_pages WHERE id=?");
        $stmt->bind_param("i", $this->id);
        return $stmt->execute();
    }
}
