<?php
// includes/cms/Testimonial.php

class Testimonial {
    /** @var mysqli */
    private $conn;

    public int    $id;
    public string $author;
    public string $date;
    public string $testimonial;
    public int    $rating;
    public bool   $is_active;

    public function __construct(mysqli $conn) {
        $this->conn = $conn;
    }

    /** Fetch one by ID */
    public function findById(int $id): ?self {
        $stmt = $this->conn->prepare("SELECT * FROM testimonials WHERE id = ?");
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $res = $stmt->get_result()->fetch_assoc();
            if ($res) {
                $t = new self($this->conn);
                foreach ($res as $k => $v) {
                    $t->$k = $v;
                }
                return $t;
            }
        }
        return null;
    }

    /** Fetch all (most recent first) */
    public function findAll(): array {
        $result = $this->conn->query("SELECT * FROM testimonials ORDER BY date DESC");
        $all = [];
        while ($row = $result->fetch_assoc()) {
            $t = new self($this->conn);
            foreach ($row as $k => $v) {
                $t->$k = $v;
            }
            $all[] = $t;
        }
        return $all;
    }

    /** Insert or update */
   public function save(): bool {
    // pull expressions out into real variables
    $rating = (int)$this->rating;
    $active = $this->is_active ? 1 : 0;

    if (!empty($this->id)) {
        // UPDATE
        $id = $this->id;
        $stmt = $this->conn->prepare(
            "UPDATE testimonials 
               SET author = ?, date = ?, testimonial = ?, rating = ?, is_active = ?
             WHERE id = ?"
        );
        // bind_param needs variables, not expressions
        $stmt->bind_param(
            "sssiii",
            $this->author,
            $this->date,
            $this->testimonial,
            $rating,
            $active,
            $id
        );
    } else {
        // INSERT
        $stmt = $this->conn->prepare(
            "INSERT INTO testimonials 
               (author, date, testimonial, rating, is_active)
             VALUES (?,?,?,?,?)"
        );
        $stmt->bind_param(
            "sssii",
            $this->author,
            $this->date,
            $this->testimonial,
            $rating,
            $active
        );
    }

    $ok = $stmt->execute();
    if ($ok && empty($this->id)) {
        $this->id = $this->conn->insert_id;
    }
    return $ok;
}


    /** Delete this testimonial */
    public function delete(): bool {
        if (empty($this->id)) {
            return false;
        }
        $stmt = $this->conn->prepare("DELETE FROM testimonials WHERE id = ?");
        $stmt->bind_param("i", $this->id);
        return $stmt->execute();
    }
}
