<?php
// Reusable Product Box rendered with the *car card* UI (1/1 same structure/classes)
function renderProductBoxCarStyle(mysqli $conn, array $p, string $style = 'default', string $type = '')
{
  $pid = (int) $p['id'];
  $title = $p['title_he'] ?: ($p['title_ar'] ?? '');
  $img = product_thumb_url($p['images'] ?? '');
  $href = '/product.php?id=' . $pid;

  // variants & min price (reuses your helper)
  [$minPrice, $opts] = get_product_min_price_and_options($conn, $pid);
  $minPriceText = $minPrice !== null ? '₪' . number_format($minPrice, 2) : '—';
  $variantCount = is_array($opts) ? count($opts) : 0;

  // find the cheapest row (for barcode etc.)
  $cheapest = null;
  if (!empty($opts)) {
    foreach ($opts as $o) {
      if ($cheapest === null || (float) $o['price'] < (float) $cheapest['price']) {
        $cheapest = $o;
      }
    }
  }

  // show category name where the car card shows "year/type"
  $categoryName = $p['category_name'] ?? '';
  if (!$type)
    $type = $categoryName; // feed into the small line above the title
  ?>
  <div class="box-car-list <?= h($style) ?> hv-one">
    <div class="image-group relative">
      <div class="top flex-two">
        <ul class="d-flex gap-8">
          <?php if ($minPrice > 0): ?>
            <li class="flag-tag warning"><?= h($minPriceText) ?></li>
          <?php endif; ?>

        </ul>
        <!--<div class="year flag-tag"><?= h($categoryName) ?></div>-->
      </div>

      <a href="<?= h($href) ?>" style="display:block">
        <div class="img-style">
          <img src="<?= h($img) ?>" alt="<?= h($title) ?>" loading="lazy">
        </div>
      </a>
    </div>

    <div class="content">
      <!-- <div class="text-address">
        <p class="text-color-3 font"><?= h($type) ?></p>
      </div>-->

      <h5 class="link-style-1">
        <a href="<?= h($href) ?>"><?= h($title) ?></a>
      </h5>

      <!-- keep same 'icon-box' triple; map to product-friendly info -->
      <div class="icon-box flex flex-wrap">
        <div class="icons flex-three">
          <span><?= $p['ingredients_he'] ? ($p['ingredients_he']) : '—' ?></span>
        </div>


      </div>


      <!-- <div class="money fs-20 fw-5 lh-25 text-color-3">
        ₪<span><?= $minPrice !== null ? number_format($minPrice, 2) : '—' ?></span>
      </div>-->
      <div class="days-box flex justify-space align-center">
        <?php if ($variantCount > 1) {
          ?>
          <div class="img-author">
            <svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <rect width="24" height="24" fill="white" />
              <path d="M14.5 17L9.5 12L14.5 7" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" />
            </svg> <span class="font text-color-3  fw-5"><?= (int) $variantCount ?> משקלים
            </span>
          </div>
          <?php
        }
        ?>
      
  <a href="<?= h($href) ?>" class="learn-more" aria-label="פרטים נוספים">
    <span class="circle" aria-hidden="true">
      <span class="icon arrow"></span>
    </span>
    <span class="button-text">פרטים נוספים</span>
  </a>

      </div>



      <?php if (!empty($opts)): ?>
        <!--
        <div class="mt-2">
          <table class="table table-sm product-options" style="margin:0;">
            <thead>
            <tr><th>כמות</th><th>יחידה</th><th>מחיר</th><th>ברקוד</th></tr>
            </thead>
            <tbody>
            <?php foreach ($opts as $o): ?>
              <tr>
                <td><?= h(rtrim(rtrim((string) $o['weight'], '0'), '.')) ?></td>
                <td><?= h(strtoupper((string) $o['unit'])) ?></td>
                <td>₪<?= number_format((float) $o['price'], 2) ?></td>
                <td><?= h((string) ($o['barcode'] ?? '')) ?></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
            -->
      <?php endif; ?>
    </div>
  </div>
  <?php
}
