<?php
/**
 * include למודול מוצרים בעמוד הבית
 * - טוען חיבור DB במידת הצורך
 * - מפעיל AJAX handler ויוצא אם זו בקשת AJAX
 * - מרנדר את המודול במצב embed
 */

if (!isset($conn) || !($conn instanceof mysqli)) {
  require_once __DIR__ . "/Conn.php";
}

require_once __DIR__ . '/../modules/products_module.php';

/* חשוב: לטפל בבקשות AJAX שמגיעות ל-endpoint הזה ולהפסיק */
products_module_handle_ajax($conn);

/* פרמטרים ברירת־מחדל; אפשר לעקוף עם $sliderOpts לפני ה-include */
$opts = [
  'mode'          => 'embed',
  'ajax_endpoint' => '/includes/product_slider.php',
  'view'          => 'grid',       // לעולם לא null
  // ניתן להעביר גם: 'category_id', 'limit', 'page', 'sort'
];
if (isset($sliderOpts) && is_array($sliderOpts)) {
  $opts = array_merge($opts, $sliderOpts);
}

/* רינדור המודול */
products_module_render($conn, $opts);
