<?php
$internal = true;

error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');

require_once __DIR__ . "/includes/Conn.php"; // $conn (mysqli)
if (!($conn instanceof mysqli)) { die("DB connection not available."); }

require_once __DIR__ . "/modules/products_module.php";
products_module_handle_ajax($conn); // חשוב: יענה לבקשות AJAX של המודול ויצא

// עמוד מלא – נשתמש במודול במצב עמוד
?><!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="shortcut icon" href="/assets/images/logo/Favicon.png">
  <link rel="stylesheet" href="/app/css/font-awesome.css">
  <link rel="stylesheet" href="/app/css/styles.css">
  <title>רשימת מוצרים</title>
</head>
<body class="body header-fixed">
<div id="wrapper"><div id="pagee" class="clearfix">
  <?php include './includes/header.php'; ?>

  <!-- כותרת עמוד (אפשר להשאיר/להסיר לפי הצורך) -->
  <section class="flat-title">
    <div class="container">
      <div class="row"><div class="col-lg-12">
        <div class="title-inner style">
          <div class="title-group fs-12">
            <a class="home fw-6 text-color-3" href="/">דף הבית</a>
            <span>רשימת מוצרים</span>
          </div>
        </div>
      </div></div>
    </div>
  </section>

  <!-- המודול (עמוד מלא) -->
  <?php products_module_render($conn, [
    'mode'          => 'page',
    'ajax_endpoint' => '/listing-grid3.php',
    'limit'         => 12
  ]); ?>

  <?php include './includes/footer.php'; ?>
</div></div>

<script src="/app/js/jquery.min.js"></script>
<script src="/app/js/bootstrap.min.js"></script>
<script src="/app/js/main.js"></script>
</body>
</html>
