<?php
session_set_cookie_params(86400, '/');  // session cookie lives 1 day
session_start();

if (!empty($_SESSION['is_admin'])) {
    header('Location: /my-products.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = trim($_POST['username'] ?? '');
    $pass = trim($_POST['password'] ?? '');

    if ($user === 'admin' && $pass === 'tan010203') {
        // set both a session flag and a hardened http-only cookie
        $_SESSION['is_admin'] = true;
        setcookie('is_admin', '1', time() + 86400, '/', '', false, true);

        header('Location: /my-products.php');
        exit;
    } else {
        $error = 'שם משתמש או סיסמה שגויים';
    }
}
?>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?php echo $site_name ?> - רשימת רכבים במלאי</title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">
<style>

    .tab-content{background:#fff;padding:2rem;border-radius:8px;box-shadow:0 0 10px #eee;}
    .footer-links-row{display:flex;gap:8px;margin-bottom:8px;align-items:center;}
    .footer-links-row input{flex:1;}
    .color-row{display:flex;gap:8px;}
    .color-row input[type=color]{width:40px;height:40px;border:none;}
    .color-row input[type=text]{width:80px;text-align:center;}
    .img-preview{display:block;max-width:140px;max-height:70px;margin:8px 0;}
 .color-row {
  display: flex;
  gap: 1.5rem;
  align-items: center;
}

.color-item {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.color-item label {
  margin-bottom: 0.25rem;
  font-size: 0.9rem;
}

.color-thumb {
  position: relative;
  width: 50px;
  height: 50px;
  border: 1px solid #ccc;
  border-radius: 4px;
  cursor: pointer;
  background: #fff;
}

/* the real <input type="color"> sits on top, invisible */
.color-picker {
  position: absolute;
  top:    0;
  left:   0;
  width:  100%;
  height: 100%;
  opacity: 0;
  cursor: pointer;
  border: none;
  padding: 0;
  margin: 0;
}
/* Make the modal-body fill the viewport and center its child */
.modal-body {
  display: flex !important;
  align-items: center;
  justify-content: center;
  height: 100vh;        /* full viewport height */
  padding: 0;
  margin: 0;
}
/* Ensure the inner wrap is a column so content stacks vertically */
.wrap-modal {
  display: flex;
  flex-direction: column;
  align-items: center;
  width: 100%;
}
/* Constrain the form box and center it */
.wrap-modal .content {
  max-width: 350px;
  width: 100%;
  margin: 0 auto;
}
/* Comark signature styling */
.comark-signature {
  text-align: center;
  margin-top: 2rem;
  font-size: 12px;
  color: #666;
}
.comark-logo {
  max-height: 40px;
  margin-bottom: 0.5rem;
}
.comark-text a {
  color: inherit;
  text-decoration: none;
  margin: 0 0.25rem;
}


</style>
</head>

<body class="body">

<div class="modal-body">
  <div class="wrap-modal">
    <div class="content">
      <h1 class="title-login">התחברות</h1>
      <?php if (!empty($error)): ?>
        <p style="color:red;"><?= htmlspecialchars($error) ?></p>
      <?php endif; ?>

      <form method="post" class="comment-form">
        <fieldset>
          <label class="fw-6">שם משתמש</label>
          <input type="text" name="username" class="tb-my-input" placeholder="שם משתמש" required>
          <!-- אייקון פה במידת הצורך -->
        </fieldset>

        <fieldset class="style-wrap">
          <label class="fw-6">סיסמה</label>
          <input type="password" name="password" class="password-input" placeholder="סיסמה" required>
          <!-- אייקון פה במידת הצורך -->
        </fieldset>

        <!--<div class="title-forgot">
          <a class="fs-14 fw-4">שכחת סיסמה?</a>
        </div>-->

        <button class="sc-button" type="submit">
          <span>התחבר</span>
        </button>
      </form>

      <!-- חתימת Comark -->
      <div class="comark-signature">
        <a href="https://www.comarkit.com" target="_blank" rel="noopener noreferrer">
          <img src="https://comarkit.com/delivery/footerlight.png" alt="לוגו COMARK" class="comark-logo">
        </a>
        <div class="comark-text">
          <a href="https://www.comarkit.com" target="_blank" class="comark-small-line">קומרק</a> |
          <a href="https://www.comarkit.com/web-development" target="_blank">בניית אתרים</a>
        </div>
      </div>
    </div>
  </div>
</div>



    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>
    <script src="app/js/jquery-ui.js"></script>
    



</body>

</html>