<?php
include './includes/cms/session.php';
include "./includes/Conn.php";
if (isset($_GET)) {
    $listing_only = $_GET['module'];
} else {
    $listing_only = true;

}

// ✅ How many results per page
$limit = 10;

// ✅ Get current page or set default to 1
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;

// ✅ Calculate offset
$offset = ($page - 1) * $limit;
/* ✅ קריאת פילטרים מה-URL */
$flt_make = isset($_GET['make_id']) ? (int) $_GET['make_id'] : 0;
$flt_model = isset($_GET['model_id']) ? (int) $_GET['model_id'] : 0;
$flt_type = isset($_GET['car_type']) ? trim($_GET['car_type']) : '';

/* ✅ בסיס ה-WHERE הדינמי */
$where = [];
$bind = [];
$types = '';

if ($flt_make) {
    $where[] = 'c.car_make = ?';
    $bind[] = $flt_make;
    $types .= 'i';
}
if ($flt_model) {
    $where[] = 'c.car_model = ?';
    $bind[] = $flt_model;
    $types .= 'i';
}
if ($flt_type) {
    $where[] = 'c.car_type  = ?';
    $bind[] = $flt_type;
    $types .= 's';
}

$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

/* ✅ ספירה לצורכי פאגינציה */
$count_sql = "SELECT COUNT(*) AS total
              FROM cars_sale_inventory c
              $where_sql";
$stmt_cnt = $conn->prepare($count_sql);
if ($types)
    $stmt_cnt->bind_param($types, ...$bind);
$stmt_cnt->execute();
$total_rows = $stmt_cnt->get_result()->fetch_assoc()['total'];

/* ✅ שליפת הנתונים */
$sql = "SELECT c.id, c.title, c.manufacture_year, c.price, c.color, c.mileage,
               c.transmission_type, c.fuel_type, c.images, c.date_added,
               c.car_type,
               m.make_name, mo.model_name
        FROM cars_sale_inventory c
        LEFT JOIN car_makes  m  ON c.car_make  = m.id
        LEFT JOIN car_models mo ON c.car_model = mo.id
        $where_sql
        ORDER BY c.date_added DESC
        LIMIT ? OFFSET ?";

$stmt = $conn->prepare($sql);

/* ‏‎$bind + ‎LIMIT‎ + ‎OFFSET‎ */
$types_all = $types . 'ii';
$bind_all = array_merge($bind, [$limit, $offset]);
$stmt->bind_param($types_all, ...$bind_all);

$stmt->execute();
$result = $stmt->get_result();

$tot  = (int)$conn->query("SELECT COUNT(*) n FROM cars_sale_inventory")->fetch_assoc()['n'];
$sold = (int)$conn->query("SELECT COUNT(*) n FROM cars_sale_inventory WHERE status='sold'")->fetch_assoc()['n'];
$hid  = (int)$conn->query("SELECT COUNT(*) n FROM cars_sale_inventory WHERE status='hidden'")->fetch_assoc()['n'];
$pend = (int)$conn->query("SELECT COUNT(*) n FROM cars_sale_inventory WHERE status='pending'")->fetch_assoc()['n'];

/* כמה מודעות מותרות?  (אם אין לך מגבלה אפשר להשמיט) */
$quota = 50;
$remain = max($quota - $tot, 0);
?>


<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?php echo $site_name ?> - רשימת רכבים במלאי</title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">

</head>

<body class="body">

    <!-- dashboard -->
    <div class="dashboard-overlay"></div>
    <?php include './includes/cms/aside.php'; ?>

    <div id="wrapper-dashboard">
        <div id="pagee" class="clearfix">

            <?php include './includes/cms/header.php'; ?>

        </div>

        <div id="themesflat-content">
            <div class="dashboard-toggle">Show DashBoard</div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-area">
                            <main id="main" class="main-content">
                                <div class="tfcl-dashboard">

                                    <?php
                                    if ($listing_only == false AND !isset($_GET['make_id'])) {
                                        ?>
                                        <header class="topbar">
                                            <h1>לוח בקרה</h1>
                                        </header>

                                        <!-- ===== DASHBOARD OVERVIEW ===== -->
                                        <div class="tfcl-dashboard-overview ">
                                            <div class="row g-4">
                                                <!-- g-4 = מרווחים; שים לב ש-Bootstrap RTL צריך dir=rtl בהורה -->
                                                <!-- 1. Your listings -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview1.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>המודעות שלי</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <div class="listing-text d-flex">
                                                                        <b><?= $tot ?></b>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <!-- 2. Pending -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php?filter=pending">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview4.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>ממתינות</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <span><b><?= $pend ?></b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <!-- 3. Hidden -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php?filter=hidden">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview3.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>מוסתרות</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <span><b><?= $hid ?></b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <!-- 4. Sold -->
                                                <div class="col-sm-6 col-xl-3">
                                                    <a class="tfcl-card" href="my-listing.php?filter=sold">
                                                        <div class="card-body">
                                                            <div class="tfcl-icon-overview">
                                                                <img src="assets/images/dashboard/overview2.svg" alt="icon">
                                                            </div>
                                                            <div class="content-overview">
                                                                <h5>נמכרו</h5>
                                                                <div class="tfcl-dashboard-title">
                                                                    <span><b><?= $sold ?></b></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div><!-- /.row -->
                                        </div><!-- /.tfcl-dashboard-overview -->
                                        <?php
                                    } else {
                                        ?>


                                        <h1 class="admin-title mb-3"><?php echo $site_name ?> - רשימת רכבים במלאי</h1>


                                        <?php
                                    }
                                    ?>


                                    <div class="tfcl-dashboard-middle mt-2">
                                        <div class="row">
                                            <div class="tfcl-dashboard-middle-left col-md-12">
                                                <div class="tfcl-dashboard-listing">


                                                    <form id="filterForm" class="row g-2 mb-3" method="GET" action="">
                                                        <!-- ‎1. יצרן -->
                                                        <div class="col-xl-3 col-lg-6">
                                                            <select name="make_id" id="f-make" class="form-control">
                                                                <option value="">כל היצרנים</option>
                                                                <?php
                                                                $makes_opt = $conn->query("SELECT id,make_name FROM car_makes ORDER BY make_name");
                                                                while ($m = $makes_opt->fetch_assoc()):
                                                                    ?>
                                                                    <option value="<?= $m['id'] ?>"
                                                                        <?= $m['id'] == $flt_make ? 'selected' : '' ?>>
                                                                        <?= $m['make_name'] ?>
                                                                    </option>
                                                                <?php endwhile; ?>
                                                            </select>
                                                        </div>

                                                        <!-- ‎2. דגם (מתמלא דינמית) -->
                                                        <div class="col-xl-3 col-lg-6">
                                                            <select name="model_id" id="f-model" class="form-control">
                                                                <option value="">כל הדגמים</option>
                                                                <!-- אופציות ייטענו ב-JS -->
                                                            </select>
                                                        </div>

                                                        <!-- ‎3. סוג רכב -->
                                                        <div class="col-xl-3 col-lg-6">
                                                            <select name="car_type" class="form-control">
                                                                <option value="">כל הסוגים</option>
                                                                <?php foreach (['SUV', '4x4', 'Private', 'Small', 'Coupe', 'Pickup'] as $t): ?>
                                                                    <option <?= $t == $flt_type ? 'selected' : '' ?>><?= $t ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>

                                                        <!-- ‎4. כפתור סינון -->
                                                        <div class="col-xl-3 col-lg-6 d-grid" >
 <div class="modal-footer group-button-submit d-flex align-items-center " >
                                                            <button class="pre-btn wide" type="submit">סנן</button>
                                                        </div>                                                        </div>
                                                    </form>




                                                    <div class="tfcl-table-listing">
                                                        <div class="table-responsive">
                                                            <span class="result-text">
                                                                <b><?= $total_rows ?></b> רכבים במלאי
                                                            </span>

                                                            <table class="table">
                                                                <thead>
                                                                    <tr>
                                                                        <th>פרטי רכב</th>
                                                                        <th>מצב מודעה</th>
                                                                        <th>תאריך פרסום</th>
                                                                        <th>פעולות</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tfcl-table-content">

                                                                    <?php while ($car = $result->fetch_assoc()): ?>
                                                                        <tr>
                                                                            <!-- ✅ LISTING COLUMN -->
                                                                            <td class="column-listing">
                                                                                <div class="tfcl-listing-product">
                                                                                    <a
                                                                                        href="add-listing.php?id=<?= $car['id'] ?>">
                                                                                        <img src="<?= $static_files_domain ?><?= !empty($car['images']) ? $car['images'] : 'assets/images/dashboard/default-car.jpg' ?>"
                                                                                            alt="<?= $car['make_name'] . ' ' . $car['model_name'] ?>"
                                                                                            width="100">
                                                                                    </a>
                                                                                    <div class="tfcl-listing-summary">
                                                                                        <h4 class="tfcl-listing-title">
                                                                                            <a
                                                                                                href="add-listing.php?id=<?= $car['id'] ?>">
                                                                                                <?= htmlspecialchars($car['manufacture_year'] . ' ' . $car['make_name'] . ' ' . $car['model_name']) ?>
                                                                                            </a>
                                                                                        </h4>
                                                                                        <div class="features-text">
                                                                                            <?= number_format($car['mileage']) ?>
                                                                                            ק"מ,
                                                                                            <?= htmlspecialchars($car['transmission_type']) ?>,
                                                                                            <?= htmlspecialchars($car['fuel_type']) ?>
                                                                                        </div>
                                                                                        <div class="price">
                                                                                            <div
                                                                                                class="inner tfcl-listing-price">
                                                                                                ₪<?= number_format($car['price']) ?>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </td>

                                                                            <!-- ✅ STATUS COLUMN -->
                                                                            <td class="column-status">
                                                                                <span
                                                                                    class="tfcl-listing-status status-publish">
                                                                                    Approved
                                                                                </span>
                                                                            </td>

                                                                            <!-- ✅ POSTING DATE COLUMN -->
                                                                            <td class="column-date">
                                                                                <div class="tfcl-listing-date">
                                                                                    <?= date("F d, Y", strtotime($car['date_added'])) ?>
                                                                                </div>
                                                                            </td>

                                                                            <!-- ✅ ACTION COLUMN -->
                                                                            <td class="column-controller">
                                                                                <div class="inner-controller">
                                                                                    <span class="icon"><img
                                                                                            src="assets/images/dashboard/pen.svg"></span>
                                                                                    <a href="add-listing.php?id=<?= $car['id'] ?>"
                                                                                        class="btn-action">עריכה</a>
                                                                                </div>
                                                                                <div class="inner-controller">
                                                                                    <span class="icon"><img
                                                                                            src="assets/images/dashboard/plus-square.svg"></span>
                                                                                    <a href="#" data-id="<?= $car['id'] ?>"
                                                                                        class="btn-action btn-story">סטורי</a>
                                                                                </div>
                                                                                <div class="inner-controller">
                                                                                    <span class="icon"><img
                                                                                            src="assets/images/dashboard/trash.svg"></span>
                                                                                    <a href="delete_car.php?id=<?= $car['id'] ?>"
                                                                                        onclick="return confirm('למחוק?')"
                                                                                        class="btn-action">מחיקה</a>
                                                                                </div>
                                                                            </td>

                                                                        </tr>
                                                                    <?php endwhile; ?>

                                                                </tbody>
                                                            </table>
                                                        </div>

                                                        <!-- ✅ PAGINATION (Dynamic) -->
                                                        <div class="tfcl-pagination paging-navigation clearfix">
                                                            <?php if ($page > 1): ?>
                                                                <a class="prev page-numbers"
                                                                    href="?page=<?= $page - 1 ?>"><i
                                                                        class="far fa-angle-right"></i></a>
                                                            <?php endif; ?>

                                                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                                                <a class="page-numbers <?= ($i == $page) ? 'current' : '' ?>"
                                                                    href="?page=<?= $i ?>"><?= $i ?></a>
                                                            <?php endfor; ?>

                                                            <?php if ($page < $total_pages): ?>
                                                                <a class="next page-numbers"
                                                                    href="?page=<?= $page + 1 ?>"><i
                                                                        class="far fa-angle-left"></i></a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>



                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </main>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php include './includes/cms/modales.php'; ?>

    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>
    <script src="app/js/jquery-ui.js"></script>
    <script src="app/js/dashboard.js"></script>
    <!-- modal story -->
    <div id="storyModal" class="modal">
        <div class="modal-box">
            <h3>יצירת סטורי (בהמשך…)</h3>
            <button id="storyOk" class="sc-button">סגור</button>
        </div>
    </div>

    <script>
        /* inline edit make/model -------------------------------------------------- */
        $('select.inline-edit').change(function () {
            $.post('api_update_car.php', {
                id: $(this).data('id'),
                field: $(this).data('field'),
                value: this.value
            });
        });

        /* story modal -------------------------------------------------------------*/
        $('.btn-story').click(function (e) {
            e.preventDefault();
            console.log('create story for car #' + $(this).data('id'));
            $('#storyModal').show();
        });
        $('#storyOk').click(() => $('#storyModal').hide());

        /* ----- מילוי דגם בהתאם ליצרן ----- */
        const MODELS = {};   // ייטען ב-AJAX פעם אחת
        $.getJSON('ajax_cars.php', { action: 'make_model_lists' }, res => {
            Object.assign(MODELS, res.models || {});
            fillModels($('#f-make').val());
        });

        /* שינוי יצרן */
        $('#f-make').on('change', function () {
            $('#f-model').val('');                    // ריסט
            fillModels(this.value);
        });
        function fillModels(makeId) {
            const $md = $('#f-model').empty()
                .append('<option value="">כל הדגמים</option>');
            (MODELS[makeId] || []).forEach(md => {
                $md.append(`<option value="${md.id}">${md.model_name}</option>`);
            });
            /* שחזור בחירה אם חזרנו מ-GET */
            const sel = <?= (int) $flt_model ?>;
            if (sel) $md.val(sel);
        }

    </script>

</body>

</html>