<?php
include "./includes/Conn.php";
?>


<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?php echo $site_name ?> - רשימת רכבים במלאי</title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">

</head>

<body class="body">

    <!-- dashboard -->
    <div class="dashboard-overlay"></div>
    <?php include './includes/cms/aside.php'; ?>

    <div id="wrapper-dashboard">
        <div id="pagee" class="clearfix">

            <?php include './includes/cms/header.php'; ?>

        </div>

        <div id="themesflat-content">
            <div class="dashboard-toggle">Show DashBoard</div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-area">
                            <main id="main" class="main-content">
                                <div class="tfcl-dashboard">

                                    

                                    <div class="tfcl-dashboard-middle mt-2">
                                        <div class="row">
                                            <div class="tfcl-dashboard-middle-left col-md-12">
                                                <div class="tfcl-dashboard-listing">


                                                   




                                                    <div class="tfcl-table-listing">
                                                      <!-- ======================= הצגת פניות טופס יצירת קשר ======================= -->
<div class="tfcl-dashboard-messages mb-5">
    <h2 class="admin-title mb-3">פניות מהאתר (טופס יצירת קשר)</h2>
    <?php
    // Fetch latest messages, newest first
    $messages_q = $conn->query("SELECT id, name, tel, subject, message, created_at 
                                FROM contact_us 
                                ORDER BY created_at DESC LIMIT 20");
    if ($messages_q && $messages_q->num_rows > 0):
    ?>
        <div class="table-responsive">
            <table class="table table-bordered" style="background:#fff">
                <thead>
                    <tr>
                        <th>שם</th>
                        <th>טלפון</th>
                        <th>נושא</th>
                        <th>הודעה</th>
                        <th>תאריך</th>
                        <th>פעולות</th>
                    </tr>
                </thead>
                <tbody>
                <?php while($msg = $messages_q->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($msg['name']) ?></td>
                        <td dir="ltr" style="direction:ltr"><?= htmlspecialchars($msg['tel']) ?></td>
                        <td><?= htmlspecialchars($msg['subject']) ?></td>
                        <td>
                            <div style="max-width:180px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;direction:rtl;">
                                <?= htmlspecialchars(mb_substr($msg['message'],0,40)) ?>
                                <?php if(mb_strlen($msg['message']) > 40): ?>
                                    ... <a href="#" class="view-msg" data-id="<?= $msg['id'] ?>">[קרא הכל]</a>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td><?= date('d/m/Y H:i', strtotime($msg['created_at'])) ?></td>
                        <td>
                            <button class="btn btn-secondary btn-sm view-msg" data-id="<?= $msg['id'] ?>">הצג</button>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p>לא נמצאו פניות.</p>
    <?php endif; ?>
</div>

<!-- Modal for viewing messages -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="direction:rtl;text-align:right">
      <div class="modal-header">
        <h5 class="modal-title" id="messageModalLabel">פרטי פנייה</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="סגור"></button>
      </div>
      <div class="modal-body" id="messageModalBody">
        <!-- AJAX content will go here -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">סגור</button>
      </div>
    </div>
  </div>
</div>


                                                        <!-- ✅ PAGINATION (Dynamic) -->
                                                        <div class="tfcl-pagination paging-navigation clearfix">
                                                            <?php if ($page > 1): ?>
                                                                <a class="prev page-numbers"
                                                                    href="?page=<?= $page - 1 ?>"><i
                                                                        class="far fa-angle-right"></i></a>
                                                            <?php endif; ?>

                                                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                                                <a class="page-numbers <?= ($i == $page) ? 'current' : '' ?>"
                                                                    href="?page=<?= $i ?>"><?= $i ?></a>
                                                            <?php endfor; ?>

                                                            <?php if ($page < $total_pages): ?>
                                                                <a class="next page-numbers"
                                                                    href="?page=<?= $page + 1 ?>"><i
                                                                        class="far fa-angle-left"></i></a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>



                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </main>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php include './includes/cms/modales.php'; ?>

    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>
    <script src="app/js/jquery-ui.js"></script>
    <script src="app/js/dashboard.js"></script>
    <!-- modal story -->
  

    <script>
   
// View full message modal (AJAX)
$('.tfcl-dashboard-messages').on('click', '.view-msg', function(e) {
    e.preventDefault();
    var msgId = $(this).data('id');
    if (!msgId) return;
    $('#messageModalLabel').text('פרטי פנייה #' + msgId);
    $('#messageModalBody').html('<div class="loader-illusion"><span></span><span></span><span></span></div>');

    $.get('admin_message_view.php', {id: msgId}, function(res) {
        $('#messageModalBody').html(res);
    }).fail(function() {
        $('#messageModalBody').html('<div class="text-danger">אירעה שגיאה, נסה שוב</div>');
    });

    $('#messageModal').modal('show');
});

    </script>

</body>

</html>