<?php
// ../admin/static-pages.php

error_reporting(E_ALL);
ini_set('display_errors','1');

// 1) Connect via mysqli ($conn)
require __DIR__ . '/includes/Conn.php';

// 2) Uploads constants
define('UPLOADS_DIR', __DIR__ . '/../uploads/');
define('UPLOADS_URL', '/uploads/');

// 3) AJAX endpoint for editing
if (isset($_GET['ajax'], $_GET['id'])) {
    require __DIR__ . '/includes/cms/StaticPage.php';
    $model = new StaticPage($conn);
    $p = $model->findById((int)$_GET['id']);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'id'            => $p->id,
        'title'         => $p->title,
        'slug'          => $p->slug,
        'content'       => $p->content,
        'image_path'    => $p->image_path,
        'is_active'     => $p->is_active,
        'show_in_menu'  => $p->show_in_menu,
        'show_in_footer'=> $p->show_in_footer,
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// 4) Load model
require __DIR__ . '/includes/cms/StaticPage.php';
$model = new StaticPage($conn);

// 5) Handle deletion
if (isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    if ($id && $page = $model->findById($id)) {
        $page->delete();
    }
    header('Location: static-pages.php');
    exit;
}

// 6) Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = !empty($_POST['id']) ? (int)$_POST['id'] : null;
    $page = $id ? $model->findById($id) : new StaticPage($conn);
    if (!$page) { $page = new StaticPage($conn); }

    // Assign
    $page->title          = trim($_POST['title']);
    $page->slug           = trim($_POST['slug']);
    $page->content        = $_POST['content'];
    $page->is_active      = !empty($_POST['is_active']);
    $page->show_in_menu   = !empty($_POST['show_in_menu']);
    $page->show_in_footer = !empty($_POST['show_in_footer']);

    // Image upload
    if (!empty($_FILES['image']['tmp_name'])) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $fn  = 'page_' . time() . '.' . $ext;
        if (move_uploaded_file($_FILES['image']['tmp_name'], UPLOADS_DIR . $fn)) {
            $page->image_path = UPLOADS_URL . $fn;
        }
    }

    // Save
    $page->save();
    header('Location: pages.php');
    exit;
}

// 7) Fetch all pages
$pages = $model->findAll();
?><!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?php echo $site_name ?> - רשימת רכבים במלאי</title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">
<style>

    .tab-content{background:#fff;padding:2rem;border-radius:8px;box-shadow:0 0 10px #eee;}
    .footer-links-row{display:flex;gap:8px;margin-bottom:8px;align-items:center;}
    .footer-links-row input{flex:1;}
    .color-row{display:flex;gap:8px;}
    .color-row input[type=color]{width:40px;height:40px;border:none;}
    .color-row input[type=text]{width:80px;text-align:center;}
    .img-preview{display:block;max-width:140px;max-height:70px;margin:8px 0;}
 .color-row {
  display: flex;
  gap: 1.5rem;
  align-items: center;
}

.color-item {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.color-item label {
  margin-bottom: 0.25rem;
  font-size: 0.9rem;
}

.color-thumb {
  position: relative;
  width: 50px;
  height: 50px;
  border: 1px solid #ccc;
  border-radius: 4px;
  cursor: pointer;
  background: #fff;
}

/* the real <input type="color"> sits on top, invisible */
.color-picker {
  position: absolute;
  top:    0;
  left:   0;
  width:  100%;
  height: 100%;
  opacity: 0;
  cursor: pointer;
  border: none;
  padding: 0;
  margin: 0;
}

</style>
</head>

<body class="body">

    <!-- dashboard -->
    <div class="dashboard-overlay"></div>
    <?php include './includes/cms/aside.php'; ?>

    <div id="wrapper-dashboard">
        <div id="pagee" class="clearfix">

            <?php include './includes/cms/header.php'; ?>

        </div>

        <div id="themesflat-content">
            <div class="dashboard-toggle">Show DashBoard</div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-area">
<div class="container">
    <div class="modal-footer group-button-submit justi d-flex justify-content-between align-items-center">
    <h1 class="mb-4">ניהול דפים סטטיים</h1>
    <!-- Create button -->
    <button class="pre-btn mb-3" onclick="openModal();">
      + צור דף חדש
    </button>
</div>
    <!-- Pages table -->
    <table class="table table-striped">
      <thead class="table-light">
        <tr>
          <th>כותרת</th>
          <th>פעיל</th>
          <th>בתפריט</th>
          <th>בפוטר</th>
          <th>עריכה</th>
          <th>מחיקה</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($pages as $p): ?>
        <tr>
          <td><?= htmlspecialchars($p->title) ?></td>
          <td><?= $p->is_active ? 'כן' : 'לא' ?></td>
          <td><?= $p->show_in_menu ? 'כן' : 'לא' ?></td>
          <td><?= $p->show_in_footer ? 'כן' : 'לא' ?></td>
          <td>
            <button class="btn btn-sm btn-outline-secondary" onclick="openModal(<?= $p->id ?>)">ערוך</button>
          </td>
          <td>
            <a href="?del=<?= $p->id ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('בטוח שברצונך למחוק?');">X</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <!-- Modal -->
    <div class="modal fade" id="pageModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <form id="pageForm" method="post" enctype="multipart/form-data">
            <div class="modal-header">
              <h5 class="modal-title" id="modalTitle">צור/ערוך דף</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <input type="hidden" name="id" id="pageId">
              <div class="mb-3">
                <label class="form-label">כותרת</label>
                <input type="text" name="title" id="pageTitle" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Slug</label>
                <input type="text" name="slug" id="pageSlug" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">תוכן מלא</label>
                <div id="editor" style="height: 200px; background: #fff;"></div>
                <textarea name="content" id="pageContent" class="visually-hidden"></textarea>
              </div>
              <div class="mb-3">
                <label class="form-label">תמונה ראשית</label>
                <input type="file" name="image" class="form-control">
                <div id="existingImage" class="mt-2"></div>
              </div>
              <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="is_active" id="pageActive">
                <label class="form-check-label" for="pageActive">פעיל</label>
              </div>
              <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="show_in_menu" id="pageMenu">
                <label class="form-check-label" for="pageMenu">להראות בתפריט ראשי</label>
              </div>
              <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="show_in_footer" id="pageFooter">
                <label class="form-check-label" for="pageFooter">להראות בפוטר</label>
              </div>
            </div>
           <div class="modal-footer group-button-submit left mb-3">
              <button type="button" class="pre-btn" data-bs-dismiss="modal">ביטול</button>
              <button type="submit" class="pre-btn">שמירה</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>
    <script src="app/js/jquery-ui.js"></script>
    
    
  <link href="https://cdn.jsdelivr.net/npm/quill@1.3.7/dist/quill.snow.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/quill@1.3.7/dist/quill.min.js"></script>

  <script>
    let quill;
    document.addEventListener('DOMContentLoaded', () => {
      quill = new Quill('#editor', { theme: 'snow', modules: { toolbar: true } });
    });

    function openModal(id = 0) {
      const modalEl = document.getElementById('pageModal');
      const modal = new bootstrap.Modal(modalEl);
      document.getElementById('pageForm').reset();
      quill.setContents([{ insert: '' }]);
      document.getElementById('existingImage').innerHTML = '';
      document.getElementById('pageId').value = '';
      document.getElementById('modalTitle').innerText = id ? 'ערוך דף' : 'צור דף חדש';
      if (id) {
        fetch(`?ajax=1&id=${id}`)
          .then(res => res.json())
          .then(p => {
            document.getElementById('pageId').value = p.id;
            document.getElementById('pageTitle').value = p.title;
            document.getElementById('pageSlug').value = p.slug;
            quill.root.innerHTML = p.content;
            document.getElementById('pageActive').checked = !!p.is_active;
            document.getElementById('pageMenu').checked = !!p.show_in_menu;
            document.getElementById('pageFooter').checked = !!p.show_in_footer;
            if (p.image_path) {
              document.getElementById('existingImage').innerHTML = `<img src="${p.image_path}" class="img-thumbnail" width="150">`;
            }
            modal.show();
          });
      } else {
        modal.show();
      }
    }

    document.getElementById('pageForm').addEventListener('submit', function() {
      document.getElementById('pageContent').value = quill.root.innerHTML;
    });
  </script>


</body>

</html>