<?php
include './includes/cms/session.php';
/*-------------------------------------------------
|  DB & early-exit
-------------------------------------------------*/
include "./includes/Conn.php";
if (empty($_POST)) exit;                     // no direct hits
/*-------------------------------------------------
|  1) INPUT SANITISE & NORMALISE
-------------------------------------------------*/
$id        = $_POST['car_id'] ?? null;                     // null ⇒ INSERT
$title     = trim($_POST['title'] ?? '');

$make_id   = (int)$_POST['make_id'];
$model_id  = (int)$_POST['model_id'];

$year      = (int)$_POST['manufacture_year'];
if ($year < 1900 || $year > date('Y') + 1) die('שנת יצור לא תקינה');

$mileage   = (int)($_POST['mileage'] ?? 0);
$trans     = trim($_POST['transmission_type'] ?? '');
$fuel      = trim($_POST['fuel_type']         ?? '');
$color     = trim($_POST['color']             ?? '');
$price     = (float)$_POST['price'];
$desc      = trim($_POST['description']       ?? '');

/* --- NEW FIELDS --- */
$hand              = (int)($_POST['hand'] ?? 1);
$kilometers        = (int)($_POST['kilometers'] ?? 0);
$engine_power_kw   = ($_POST['engine_power_kw']   !== '') ? (int)$_POST['engine_power_kw']   : null;
$horsepower        = ($_POST['horsepower']        !== '') ? (int)$_POST['horsepower']        : null;
$seating_capacity  = ($_POST['seating_capacity']  !== '') ? (int)$_POST['seating_capacity']  : null;

// ** ADD THIS: read car_type from POST **
$car_type = trim($_POST['car_type'] ?? '');

// now validate it
// sanitize
$car_type_id = isset($_POST['car_type_id'])
    ? (int)$_POST['car_type_id']
    : null;

$is_4x4            = isset($_POST['is_4x4']) ? 1 : 0;

/*-------------------------------------------------
|  2) GALLERY — delete / uploads / ordering
-------------------------------------------------*/
$old_gallery = json_decode($_POST['old_gallery_json'] ?? '[]', true);
if (!is_array($old_gallery)) $old_gallery = [];

$old_main    = $_POST['old_images'] ?? null;

/* remove selected old images */
if (!empty($_POST['delete_images'])) {
    $toDel       = array_map('trim', (array)$_POST['delete_images']);
    $old_gallery = array_values(array_diff($old_gallery, $toDel));
    if (in_array($old_main, $toDel)) $old_main = $old_gallery[0] ?? null;
}

/* --- paths --- */
$uploadDirAbs = __DIR__ . '/uploads';
$uploadDirRel = 'uploads';
if (!is_dir($uploadDirAbs)) mkdir($uploadDirAbs, 0775, true);

/* helper */
function storeFile(array $f, string $abs, string $rel): ?string {
    if ($f['error'] || !is_uploaded_file($f['tmp_name'])) return null;
    $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
    if (!preg_match('/^(jpg|jpeg|png|gif|webp)$/', $ext))  return null;

    $fn = uniqid('img_', true) . '.' . $ext;
    if (!move_uploaded_file($f['tmp_name'], "$abs/$fn"))    return null;
    chmod("$abs/$fn", 0664);
    return "$rel/$fn";
}

/* main image */
$mainImg = $old_main;
if (!empty($_FILES['main_image_file']['name'])) {
    $mainImg = storeFile($_FILES['main_image_file'], $uploadDirAbs, $uploadDirRel) ?: $mainImg;
} elseif (!empty($_POST['main_img_url'])) {
    $mainImg = trim($_POST['main_img_url']);
}

/* new gallery files */
$new_gallery = [];
if (!empty($_FILES['images']['name'][0])) {
    foreach ($_FILES['images']['tmp_name'] as $i => $tmp) {
        $file = [
            'name'     => $_FILES['images']['name'][$i],
            'tmp_name' => $tmp,
            'error'    => $_FILES['images']['error'][$i],
        ];
        if ($url = storeFile($file, $uploadDirAbs, $uploadDirRel)) $new_gallery[] = $url;
    }
}

/* merge & sort */
$gallery = array_values(array_merge($old_gallery, $new_gallery));

if (!empty($_POST['gallery_sort_json'])) {
    $order = json_decode($_POST['gallery_sort_json'], true);
    if (is_array($order)) {
        $ordered = [];
        foreach ($order as $src)
            if (($k = array_search($src, $gallery)) !== false)
                $ordered[] = $gallery[$k];
        $gallery = array_values(array_unique(array_merge($ordered, $gallery)));
    }
}
if ($mainImg && !in_array($mainImg, $gallery)) array_unshift($gallery, $mainImg);

$gallery  = array_slice($gallery, 0, 10);          // hard-cap 10 images
$mainImg  = $gallery[0] ?? null;                   // (re-)assign main
$gJson    = json_encode($gallery, JSON_UNESCAPED_UNICODE);
/* ==== 1) קולט את road_date מה-FORM ==== */
$road_month = trim($_POST['road_date'] ?? '');          // YYYY-MM מה-input type="month"
if ($road_month && preg_match('/^\d{4}\-(0[1-9]|1[0-2])$/', $road_month)) {
    $road_date = $road_month . '-01';                   // הופך ל-DATE מלא YYYY-MM-01
} else {
    die('תאריך עלייה לכביש לא תקין');
}
/*-------------------------------------------------
| 3) SQL – INSERT / UPDATE
-------------------------------------------------*/

/*-------------------------------------------------
| 3) SQL – INSERT / UPDATE
|    הגדרות ‎$types‎ לפני ה-if, אחת לכל פעולת SQL
-------------------------------------------------*/

/*      UPDATE: 21 פרמטרים  */
$typesUpdate  = 'siiisiiiiisiisssdsssi';

/*      INSERT: 20 פרמטרים – בלי $id  */
$typesInsert = 'siiisiiiiisiisssdsss';

if ($id) {         /* ---------- UPDATE ---------- */
    $sql = "UPDATE cars_sale_inventory SET
               title            = ? ,
               car_make         = ? ,
               car_model        = ? ,
               manufacture_year = ? ,
               road_date        = ? ,
               hand             = ? ,
               kilometers       = ? ,
               engine_power_kw  = ? ,
               horsepower       = ? ,
               seating_capacity = ? ,
               car_type_id         = ? ,
               is_4x4           = ? ,
               mileage          = ? ,
               transmission_type= ? ,
               fuel_type        = ? ,
               color            = ? ,
               price            = ? ,
               description      = ? ,
               images           = ? ,
               gallery          = ?
             WHERE id = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        $typesUpdate,
        $title, $make_id, $model_id, $year, $road_date,
        $hand,  $kilometers, $engine_power_kw, $horsepower, $seating_capacity,
        $car_type_id, $is_4x4, $mileage, $trans, $fuel, $color,
        $price, $desc, $mainImg, $gJson,
        $id                                   // ה-פרמטר ה-21
    );

} else {            /* ---------- INSERT ---------- */
    $sql = "INSERT INTO cars_sale_inventory
            (title,car_make,car_model,manufacture_year,road_date,
             hand,kilometers,engine_power_kw,horsepower,seating_capacity,
             car_type_id,is_4x4,mileage,transmission_type,fuel_type,color,
             price,description,images,gallery,status,date_added)
            VALUES
            (?,?,?,?,?,
             ?,?,?,?,?, ?,?,?, ?,?,?, ?,?,?,?,'publish',NOW())";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        $typesInsert,
        $title, $make_id, $model_id, $year, $road_date,
        $hand,  $kilometers, $engine_power_kw, $horsepower, $seating_capacity,
        $car_type_id, $is_4x4, $mileage, $trans, $fuel, $color,
        $price, $desc, $mainImg, $gJson
    );
}

/*-------------------------------------------------
| 4) EXEC & REDIRECT
-------------------------------------------------*/
if (!$stmt->execute()) die("DB error: ".$stmt->error);

header("Location: my-listing.php?msg=saved");
exit;
