<?php
include './includes/cms/session.php';
// ---- DEV ERROR DISPLAY ----
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

// ---- CONFIG ----
define('DB_HOST','localhost');
define('DB_NAME','comark_flow');
define('DB_USER','root');
define('DB_PASS','Raiadv@11');
define('UPLOADS_DIR',__DIR__.'/uploads/');
define('UPLOADS_URL','/uploads/');

// ---- DB CONNECT ----
$pdo = new PDO(
  'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4',
  DB_USER,DB_PASS,
  [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]
);

// ---- AUTH (demo user=1) ----
session_start();
$user_id = 1;

// ---- HANDLER ----
$success=$error='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $tab = $_POST['tab'] ?? '';

  // 1) CHANGE PASSWORD
  if($tab==='change_password'){
    $cur = $_POST['current_password'] ?? '';
    $new = $_POST['new_password'] ?? '';
    $cnf = $_POST['confirm_password'] ?? '';
    $h = $pdo->prepare("SELECT password_hash FROM cardealer_users WHERE id=?");
    $h->execute([$user_id]);
    $hash = $h->fetchColumn();
    if(!$hash || !password_verify($cur,$hash)){
      $error="הסיסמה הנוכחית שגויה.";
    } elseif($new!==$cnf){
      $error="הסיסמאות אינן תואמות.";
    } elseif(!preg_match('/^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$/u',$new)){
      $error="הסיסמה לא עומדת בדרישות.";
    } else {
      $ph = password_hash($new,PASSWORD_DEFAULT);
      $pdo->prepare("UPDATE cardealer_users SET password_hash=? WHERE id=?")
          ->execute([$ph,$user_id]);
      $success="הסיסמה שונתה בהצלחה.";
    }
  }

  // 2) WEBSITE SETTINGS
  if($tab==='website_settings'){
    // TEXT
    $site_title = $_POST['site_title'] ?? '';
    $desc = $_POST['main_page_description'] ?? '';
    $keys = $_POST['main_page_keywords'] ?? '';
    $footer_links = $_POST['footer_links'] ?? '[]';

    // TOGGLES
    foreach([
      'allow_leads_car_page','allow_leads_homepage','allow_leads_text_pages',
      'resize_images','maintenance_mode','reviews_enabled','show_reviews_on_main'
    ] as $t){
      $$t = !empty($_POST[$t])?1:0;
    }

    // NUMERIC & OTHERS
    $cw = $_POST['car_list_image_width']?:null;
    $ch = $_POST['car_list_image_height']?:null;
    $gw = $_POST['gallery_image_width']?:null;
    $gh = $_POST['gallery_image_height']?:null;
    $msg = $_POST['maintenance_message'] ?? '';
    $colors = $_POST['default_colors'] ?? '';
    $cards = $_POST['cards_per_tab'] ?? '10';
    $grid = $_POST['grid_listing_limit'] ?? '10';
    $orient = $_POST['grid_orientation'] ?? 'user_choice';
    $loan_min = $_POST['loan_min'] ?: 0;
    $loan_max = $_POST['loan_max'] ?: 0;
    $rate = $_POST['interest_rate'] ?: 0;
    $terms_arr = $_POST['payment_terms'] ?? [];
    $terms = implode(',',$terms_arr);
    $cem = $_POST['contact_email'] ?? '';
    $cset = $_POST['contact_settings'] ?? '';

    // UPLOADS
    $favicon=$logo_dark=$logo_light=null;
    foreach(['favicon','logo_dark','logo_light'] as $f){
      if(!empty($_FILES[$f]['name']) && $_FILES[$f]['error']===0){
        $ext=pathinfo($_FILES[$f]['name'],PATHINFO_EXTENSION);
        $fn="$f_".time().".$ext";
        if(move_uploaded_file($_FILES[$f]['tmp_name'],UPLOADS_DIR.$fn)){
          $$f=UPLOADS_URL.$fn;
        }
      }
    }

    // BUILD UPDATE
    $sql = "UPDATE cardealer_settings SET
      site_title=?,main_page_description=?,main_page_keywords=?,footer_links=?,
      allow_leads_car_page=?,allow_leads_homepage=?,allow_leads_text_pages=?,resize_images=?,
      car_list_image_width=?,car_list_image_height=?,gallery_image_width=?,gallery_image_height=?,
      maintenance_mode=?,maintenance_message=?,default_colors=?,cards_per_tab=?,
      grid_listing_limit=?,grid_orientation=?,loan_min=?,loan_max=?,interest_rate=?,payment_terms=?,
      reviews_enabled=?,show_reviews_on_main=?,contact_email=?,contact_settings=?";
    $params = [
      $site_title,$desc,$keys,$footer_links,
      $allow_leads_car_page,$allow_leads_homepage,$allow_leads_text_pages,$resize_images,
      $cw,$ch,$gw,$gh,
      $maintenance_mode,$msg,$colors,$cards,
      $grid,$orient,$loan_min,$loan_max,$rate,$terms,
      $reviews_enabled,$show_reviews_on_main,$cem,$cset
    ];
    if($favicon){$sql.=",favicon_path=?";   $params[]=$favicon;}
    if($logo_dark){$sql.=",logo_dark=?";     $params[]=$logo_dark;}
    if($logo_light){$sql.=",logo_light=?";   $params[]=$logo_light;}
    $sql.=" WHERE id=1";
    $pdo->prepare($sql)->execute($params);
    $success="הגדרות האתר נשמרו בהצלחה.";
  }

  // 3) EMAIL MARKETING
  if($tab==='email_marketing'){
    $fields=['smtp_host','smtp_port','smtp_user','smtp_pass','smtp_secure','email_from','email_from_name','template_subject','template_body'];
    $csarr=[];
    foreach($fields as $f) $csarr[$f] = $_POST[$f] ?? '';
    $pdo->prepare("UPDATE cardealer_settings SET contact_settings=? WHERE id=1")
        ->execute([json_encode($csarr,JSON_UNESCAPED_UNICODE)]);
    $success="הגדרות הדיוור נשמרו בהצלחה.";
  }
}

// ---- LOAD USER & SETTINGS ----
$user = $pdo->prepare("SELECT * FROM cardealer_users WHERE id=?");
$user->execute([$user_id]);
$user = $user->fetch(PDO::FETCH_ASSOC);

$st = $pdo->query("SELECT * FROM cardealer_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$cs = json_decode($st['contact_settings'] ?? '[]', true);

// ---- LOAD LEADS ----
$page = max(1,intval($_GET['leads_page']??1));
$per = 10; $off=($page-1)*$per;
$leads = $pdo->prepare("SELECT * FROM cardealer_leads ORDER BY id DESC LIMIT ? OFFSET ?");
$leads->bindValue(1,$per,PDO::PARAM_INT);
$leads->bindValue(2,$off,PDO::PARAM_INT);
$leads->execute();
$leads=$leads->fetchAll(PDO::FETCH_ASSOC);
$total=$pdo->query("SELECT COUNT(*) FROM cardealer_leads")->fetchColumn();
$pages=ceil($total/$per);
?>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">

<head>
    <meta charset="utf-8">
    <title><?php echo $site_name ?> - רשימת רכבים במלאי</title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="app/css/font-awesome.css">
    <link rel="stylesheet" href="app/css/styles.css">


    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="assets/images/logo/Favicon.png">
    <link rel="apple-touch-icon-precomposed" href="assets/images/logo/Favicon.png">
<style>

    .tab-content{background:#fff;padding:2rem;border-radius:8px;box-shadow:0 0 10px #eee;}
    .footer-links-row{display:flex;gap:8px;margin-bottom:8px;align-items:center;}
    .footer-links-row input{flex:1;}
    .color-row{display:flex;gap:8px;}
    .color-row input[type=color]{width:40px;height:40px;border:none;}
    .color-row input[type=text]{width:80px;text-align:center;}
    .img-preview{display:block;max-width:140px;max-height:70px;margin:8px 0;}
 .color-row {
  display: flex;
  gap: 1.5rem;
  align-items: center;
}

.color-item {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.color-item label {
  margin-bottom: 0.25rem;
  font-size: 0.9rem;
}

.color-thumb {
  position: relative;
  width: 50px;
  height: 50px;
  border: 1px solid #ccc;
  border-radius: 4px;
  cursor: pointer;
  background: #fff;
}

/* the real <input type="color"> sits on top, invisible */
.color-picker {
  position: absolute;
  top:    0;
  left:   0;
  width:  100%;
  height: 100%;
  opacity: 0;
  cursor: pointer;
  border: none;
  padding: 0;
  margin: 0;
}

</style>
</head>

<body class="body">

    <!-- dashboard -->
    <div class="dashboard-overlay"></div>
    <?php include './includes/cms/aside.php'; ?>

    <div id="wrapper-dashboard">
        <div id="pagee" class="clearfix">

            <?php include './includes/cms/header.php'; ?>

        </div>

        <div id="themesflat-content">
            <div class="dashboard-toggle">Show DashBoard</div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="content-area">
                          <main class="main-content">
  <ul class="nav nav-tabs mb-4">
    <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1">החלפת סיסמה</button></li>
    <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab2">הגדרות אתר</button></li>
    <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab3">דיוור אלקטרוני</button></li>
    <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab6">קמפיינים UTM</button></li>
  </ul>

  <?php if($error): ?><div class="alert alert-danger"><?=$error?></div><?php endif;?>
  <?php if($success): ?><div class="alert alert-success"><?=$success?></div><?php endif;?>

  <div class="tab-content">

    <!-- 1: Change Password -->
    <div class="tab-pane fade show active" id="tab1">
      <form method="post" class="mb-4">
        <input type="hidden" name="tab" value="change_password">
        <div class="mb-3"><label>סיסמה נוכחית</label><input type="password" name="current_password" class="form-control" ></div>
        <div class="mb-3"><label>סיסמה חדשה</label><input type="password" name="new_password" class="form-control" ></div>
        <ul class="list-check-req mb-3">
          <li class="text-success">ספרה אחת fלפחות</li>
          <li>אות קטנה אחת לפחות</li>
          <li>אות גדולה אחת לפחות</li>
          <li>לפחות 8 תווים</li>
        </ul>
        <div class="mb-3"><label>אישור סיסמה</label><input type="password" name="confirm_password" class="form-control" ></div>
        <button class="btn btn-primary">החלף סיסמה</button>
      </form>
    </div>

    <!-- 2: Website Settings -->
    <div class="tab-pane fade" id="tab2">
      <form method="post" enctype="multipart/form-data" id="settings_form">
        <input type="hidden" name="tab" value="website_settings">
        <!-- Site Title / Desc / Keywords -->
        <div class="mb-3"><label>כותרת אתר</label><input name="site_title" class="form-control" value="<?=htmlspecialchars($st['site_title'] ?? '')?>" ></div>
        <div class="mb-3"><label>תיאור דף ראשי</label><textarea name="main_page_description" class="form-control" ><?=htmlspecialchars($st['main_page_description'] ?? '')?></textarea></div>
        <div class="mb-3"><label>מילות מפתח</label><input name="main_page_keywords" class="form-control" value="<?=htmlspecialchars($st['main_page_keywords'] ?? '')?>"></div>

        <!-- Footer Links -->
        <label class="form-label">קישורי תחתית</label>
        <div id="footer_links_container"></div>
        <button type="button" class="btn btn-outline-secondary btn-sm mb-3" onclick="addFooterLinkRow()">הוסף קישור</button>
        <input type="hidden" name="footer_links" id="footer_links_input">
<!-- inside your <form id="settings_form"> ... -->
<label class="form-label">צבעים עיקריים</label>
<div id="colors_container" class="color-row">
  <?php
    // pull and split the saved CSV of up to 5 hexes:
    $saved = explode(',', $st['default_colors'] ?? '');
    // default fallback palette:
    $fallback = ['#ffffff','#007bff','#212529','#dee2e6','#0056b3'];
    for($i=0; $i<5; $i++):
      // pick from saved or fallback:
      $hex = isset($saved[$i]) && preg_match('/^#([0-9A-Fa-f]{3}|[0-9A-Fa-f]{6})$/', $saved[$i])
             ? $saved[$i]
             : $fallback[$i];
      // labels:
      $labels = ['רקע','צבע ראשי','צבע טקסט','צבע גבול','צבע הובר'];
  ?>
  <div class="color-item">
    <label for="picker_<?= $i+1 ?>"><?= ($i+1) ?>. <?= $labels[$i] ?></label>
    <div class="color-thumb">
      <input
        type="color"
        id="picker_<?= $i+1 ?>"
        class="color-picker"
        value="<?= htmlspecialchars($hex) ?>"
      >
    </div>
  </div>
  <?php endfor; ?>
</div>

<!-- this single hidden field is sent to PHP -->
<input type="hidden" name="default_colors" id="default_colors_input">

        <!-- Image Uploads -->
        <label>פאביקון</label>
        <input type="file" name="favicon" class="form-control" accept="image/*" onchange="previewImage(event,'fav_prev')">
        <img id="fav_prev" src="<?=htmlspecialchars($st['favicon_path'] ?? '')?>" class="img-preview">

        <label>לוגו כהה</label>
        <input type="file" name="logo_dark" class="form-control" accept="image/*" onchange="previewImage(event,'ld_prev')">
        <img id="ld_prev" src="<?=htmlspecialchars($st['logo_dark'] ?? '')?>" class="img-preview">

        <label>לוגו בהיר</label>
        <input type="file" name="logo_light" class="form-control" accept="image/*" onchange="previewImage(event,'ll_prev')">
        <img id="ll_prev" src="<?=htmlspecialchars($st['logo_light'] ?? '')?>" class="img-preview">

        <!-- Payment Terms -->
        <label>מספר תשלומים</label>
        <div class="mb-3">
          <?php foreach([12,24,36,48,60,100] as $opt): ?>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="checkbox" name="payment_terms[]" value="<?=$opt?>"
                <?=in_array((string)$opt, explode(',', $st['payment_terms'] ?? ''))?'checked':''?>>
              <label class="form-check-label"><?=$opt?></label>
            </div>
          <?php endforeach;?>
        </div>

        <!-- Toggles -->
        <?php foreach([
          'allow_leads_car_page'=>'אפשר לידים בעמוד רכב',
          'allow_leads_homepage'=>'אפשר לידים בעמוד הבית',
          'allow_leads_text_pages'=>'אפשר לידים בעמודי תוכן',
          'resize_images'=>'שינוי גודל תמונות',
          'maintenance_mode'=>'אתר במצב תחזוקה',
          'reviews_enabled'=>'אפשר ביקורות גולשים',
          'show_reviews_on_main'=>'הצג ביקורות בדף ראשי'
        ] as $fld=>$lbl): ?>
          <div class="form-check mb-3">
            <input type="checkbox" name="<?=$fld?>" class="form-check-input"
              <?=$st[$fld]?'checked':''?>>
            <label class="form-check-label"><?=$lbl?></label>
          </div>
        <?php endforeach;?>

        <!-- Numeric fields -->
        <div class="row mb-3">
          <div class="col"><label>רוחב תמונה – רשימת רכבים</label>
            <input type="number" name="car_list_image_width" class="form-control"
              value="<?=htmlspecialchars($st['car_list_image_width'] ?? '')?>"></div>
          <div class="col"><label>גובה</label>
            <input type="number" name="car_list_image_height" class="form-control"
              value="<?=htmlspecialchars($st['car_list_image_height'] ?? '')?>"></div>
        </div>
        <div class="row mb-3">
          <div class="col"><label>רוחב תמונה – גלריה</label>
            <input type="number" name="gallery_image_width" class="form-control"
              value="<?=htmlspecialchars($st['gallery_image_width'] ?? '')?>"></div>
          <div class="col"><label>גובה</label>
            <input type="number" name="gallery_image_height" class="form-control"
              value="<?=htmlspecialchars($st['gallery_image_height'] ?? '')?>"></div>
        </div>
        <div class="row mb-3">
          <div class="col"><label>הלוואה מינימלית</label>
            <input type="number" step="0.01" name="loan_min" class="form-control"
              value="<?=htmlspecialchars($st['loan_min'] ?? '0')?>"></div>
          <div class="col"><label>הלוואה מקסימלית</label>
            <input type="number" step="0.01" name="loan_max" class="form-control"
              value="<?=htmlspecialchars($st['loan_max'] ?? '0')?>"></div>
          <div class="col"><label>ריבית שנתית (%)</label>
            <input type="number" step="0.01" name="interest_rate" class="form-control"
              value="<?=htmlspecialchars($st['interest_rate'] ?? '0')?>"></div>
        </div>

        <!-- Defaults -->
        <div class="mb-3"><label>כמות כרטיסים בטאב</label>
          <select name="cards_per_tab" class="form-select">
            <?php foreach(['5','10','15','20'] as $v): ?>
              <option <?=$st['cards_per_tab']==$v?'selected':''?>><?=$v?></option>
            <?php endforeach;?>
          </select>
        </div>
        <div class="mb-3"><label>כמות ברשימת גריד</label>
          <select name="grid_listing_limit" class="form-select">
            <?php foreach(['10','15','20'] as $v): ?>
              <option <?=$st['grid_listing_limit']==$v?'selected':''?>><?=$v?></option>
            <?php endforeach;?>
          </select>
        </div>
        <div class="mb-3"><label>כיוון תצוגה</label>
          <select name="grid_orientation" class="form-select">
            <?php foreach(['vertical','horizontal','user_choice'] as $v): ?>
              <option value="<?=$v?>" <?=$st['grid_orientation']==$v?'selected':''?>><?=ucfirst($v)?></option>
            <?php endforeach;?>
          </select>
        </div>

        <!-- Contact Email / SMTP JSON stub -->
        <div class="mb-3"><label>אימייל ליצירת קשר</label>
          <input type="email" name="contact_email" class="form-control"
            value="<?=htmlspecialchars($st['contact_email'] ?? '')?>"></div>
        <div class="mb-3"><label>הגדרות SMTP (JSON)</label>
          <textarea name="contact_settings" class="form-control" rows="3"><?=htmlspecialchars($st['contact_settings'] ?? '')?></textarea></div>

        <button class="btn btn-success">שמור הגדרות</button>
      </form>
    </div>

    <!-- 3: Email Marketing -->
    <div class="tab-pane fade" id="tab3">
      <form method="post" class="mb-4">
        <input type="hidden" name="tab" value="email_marketing">
        <div class="mb-3"><label>SMTP שרת</label><input name="smtp_host" class="form-control" value="<?=htmlspecialchars($cs['smtp_host']??'')?>"></div>
        <div class="mb-3"><label>פורט</label><input name="smtp_port" class="form-control" value="<?=htmlspecialchars($cs['smtp_port']??'')?>"></div>
        <div class="mb-3"><label>משתמש</label><input name="smtp_user" class="form-control" value="<?=htmlspecialchars($cs['smtp_user']??'')?>"></div>
        <div class="mb-3"><label>סיסמה</label><input type="password" name="smtp_pass" class="form-control" value="<?=htmlspecialchars($cs['smtp_pass']??'')?>"></div>
        <div class="mb-3"><label>הצפנה</label><input name="smtp_secure" class="form-control" value="<?=htmlspecialchars($cs['smtp_secure']??'')?>"></div>
        <div class="mb-3"><label>ממ</label><input name="email_from" class="form-control" value="<?=htmlspecialchars($cs['email_from']??'')?>"></div>
        <div class="mb-3"><label>שם שולח</label><input name="email_from_name" class="form-control" value="<?=htmlspecialchars($cs['email_from_name']??'')?>"></div>
        <div class="mb-3"><label>נושא</label><input name="template_subject" class="form-control" value="<?=htmlspecialchars($cs['template_subject']??'')?>"></div>
        <div class="mb-3"><label>גוף הודעה</label><textarea name="template_body" class="form-control" rows="5"><?=htmlspecialchars($cs['template_body']??'')?></textarea></div>
        <button class="btn btn-info">שמור דיוור</button>
      </form>
    </div>

    <!-- 6: UTM Generator -->
    <div class="tab-pane fade" id="tab6">
      <form id="utm_form" onsubmit="event.preventDefault();generateUtm();">
        <div class="mb-3"><label>URL בסיסי</label><input id="utm_base" class="form-control" placeholder="https://example.com"></div>
        <?php foreach(['source','medium','campaign','term','content'] as $f): ?>
          <div class="mb-3">
            <label>UTM_<?=strtoupper($f)?></label>
            <input id="utm_<?=$f?>" class="form-control" placeholder="<?=$f?>"></div>
        <?php endforeach;?>
        <button class="btn btn-primary">צור UTM</button>
      </form>
      <div class="mt-3">
        <label>כתובת:</label>
        <input id="utm_result" class="form-control mb-2" readonly>
        <button class="btn btn-outline-secondary" onclick="copyToClipboard()">העתק</button>
      </div>
    </div>

  </div>
</main>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <!-- Javascript -->
    <script src="app/js/jquery.min.js"></script>
    <script src="app/js/jquery.easing.js"></script>
    <script src="app/js/jquery.nice-select.min.js"></script>
    <script src="app/js/chart.js"></script>
    <script src="app/js/bootstrap.min.js"></script>
    <script src="app/js/main.js"></script>
    <script src="app/js/jquery-ui.js"></script>
    <script src="app/js/dashboard.js"></script>
    <!-- modal story -->
  <script>
  // 1) bind before-submit serialization
  document.getElementById('settings_form').addEventListener('submit', function(e) {
    // footer-links: collect each row’s inputs
    const footerArr = [];
    document.querySelectorAll('#footer_links_container .footer-links-row').forEach(row => {
      const inputs = row.querySelectorAll('input[type="text"]');
      footerArr.push({
        label: inputs[0].value.trim(),
        url:   inputs[1].value.trim()
      });
    });
    // inject JSON into the hidden field
    this.querySelector('input[name="footer_links"]').value = JSON.stringify(footerArr);

    // default-colors: collect all color pickers
    const colors = Array.from(document.querySelectorAll('#colors_container input[type="color"]'))
                        .map(c => c.value);
    this.querySelector('input[name="default_colors"]').value = colors.join(',');
  });

  // 2) helper to add a row
  function addFooterLinkRow(label = '', url = '') {
    const container = document.getElementById('footer_links_container');
    const row = document.createElement('div');
    row.className = 'footer-links-row';
    row.innerHTML = `
      <input type="text" class="form-control form-control-sm" placeholder="טקסט" value="${label}">
      <input type="text" class="form-control form-control-sm" placeholder="URL" value="${url}">
      <button type="button" class="btn btn-danger btn-sm">X</button>
    `;
    row.querySelector('button').addEventListener('click', () => row.remove());
    container.append(row);
  }

  // 3) initialize with your saved JSON from PHP
  (function initFooterAndColors() {
    // PHP echoes the raw JSON array literal, e.g. [{"label":"Home","url":"..."}]
    const existingFooter = <?php echo $st['footer_links'] ?: '[]'; ?>;
    existingFooter.forEach(({label, url}) => addFooterLinkRow(label, url));

  })();

  // 4) image preview (unchanged)
  function previewImage(e, id) {
    document.getElementById(id).src = URL.createObjectURL(e.target.files[0]);
  }

  // 5) UTM generator (unchanged)
  function generateUtm() {
    let u = new URL(document.getElementById('utm_base').value);
    ['source','medium','campaign','term','content'].forEach(f => {
      let v = document.getElementById('utm_'+f).value.trim();
      if (v) u.searchParams.set('utm_'+f, v);
    });
    document.getElementById('utm_result').value = u.href;
  }
  function copyToClipboard() {
    navigator.clipboard.writeText(document.getElementById('utm_result').value);
  }
(function(){
  // grab the 5 pickers by index 1–5
  const pickers = [
    document.getElementById('picker_1'),
    document.getElementById('picker_2'),
    document.getElementById('picker_3'),
    document.getElementById('picker_4'),
    document.getElementById('picker_5'),
  ];

  // hidden field
  const out = document.getElementById('default_colors_input');

  // serialize all 5 into CSV
  function serializeColors(){
    const csv = pickers.map(p=>p.value).join(',');
    out.value = csv;
  }

  // wire up each picker → live serialize
  pickers.forEach(p => {
    // on change/recolor:
    p.addEventListener('input', serializeColors);
    // clicking the thumb (its container) opens picker
    p.parentElement.addEventListener('click', ()=> p.click());
  });

  // also before form submits
  document.getElementById('settings_form')
    .addEventListener('submit', serializeColors);

  // initial write (so out.value reflects DB-loaded starts)
  serializeColors();
})();
</script>



</body>

</html>