#!/bin/sh

check_errs()
{
  if [ "${1}" -ne "0" ] ; then
    echo "**ERROR** ${2}" 
    exit ${1}
  fi
}

DownloadTrialKey()
{
    if [ ${OS} = "FreeBSD" ]; then
        fetch -q -T 3 -o ${WGET_TEMP}/${LOCAL_DIR}/trial.key $1
    else
        # -t is tries, -T is timeout
        wget -q -t 1 -T 3 --output-document=${WGET_TEMP}/${LOCAL_DIR}/trial.key $1
    fi
}

GetTrialKey()
{
    local LICENSE_SITE="http://license.litespeedtech.com/reseller/trial.key"
    local LICENSE_SITE_2="http://license2.litespeedtech.com/reseller/trial.key"

    DownloadTrialKey $LICENSE_SITE

    if [ $? -ne 0 ] ; then
        DownloadTrialKey $LICENSE_SITE_2
    fi
}

if [ $# -ne 7 ] ; then
    check_errs 1 "Illegal parameters!"
fi

WGET_TEMP=/usr/src/lsws
LSWS_HOME=$1
SERIAL=$2
PORT_OFFSET=$3
PHP_SUEXEC=$4
ADMIN_LOGIN=$5
ADMIN_PASS=$6
ADMIN_EMAIL=$7

CUR_DIR=`pwd`
PF=`uname -p`
OS=`uname -s`


echo "... Detecting platform ..."

if [ "x$OS" = "xFreeBSD" ] ; then
    
    if [ "x$PF" = "xi386" ]; then
        PLATFORM="-i386-freebsd6"
    elif [ "x$PF" = "xamd64" ]; then
        PLATFORM="-x86_64-freebsd6"
    else
        check_errs 1 "unkown platform '$PL' for FreeBSD."
    fi
elif [ "x$OS" = "xSunOS" ]; then
    
    if [ "x$PF" = "xi386" ]; then
        BITS=`isainfo -b`    
        if [ "x$BITS" = "x64" ]; then
            PLATFORM="-x86_64-solaris"
        else
            PLATFORM="-i386-solaris"
        fi
    else
        check_errs 1 "unkown platform '$PL' for Sun Solaris."
    fi
elif [ "x$OS" = "xLinux" ]; then
    PF=`uname -m`
    
    if [ "x$PF" = "xi686" ] || [ "x$PF" = "xi586" ] || [ "x$PF" = "xi486" ] || [ "x$PF" = "xi386" ]; then
        PLATFORM="-i386-linux"
    elif [ "x$PF" = "xx86_64" ]; then
        PLATFORM="-x86_64-linux"
    else
        check_errs 1 "unkown platform '$PL' for Linux."
    fi
fi

echo "Platform is $PLATFORM"
echo ""

#latest version from wget

echo "... Query latest release version ..."

DOWNLOAD_URL="http://update.litespeedtech.com/ws/latest.php"

OUTPUT=`wget -q --output-document=- $DOWNLOAD_URL`

REL_VERSION=`expr "$OUTPUT" : '.*LSWS_STABLE=\([0-9\.]*\)'`
STABLE_BUILD=''

if [ "x${REL_VERSION}" != "x" ]
then
    REL_TYPE='stable'
    STABLE_BUILD=`expr "$OUTPUT" : '.*LSWS_STABLE=[0-9\.]* BUILD \([0-9]*\)'`
else
    REL_TYPE='edge'
    REL_VERSION=`expr "$OUTPUT" : '.*LSWS=\([0-9\.]*\)'`
fi

echo "Lastest ${REL_TYPE} version is ${REL_VERSION}"
echo ""
 
MAJOR_VERSION=`expr $REL_VERSION : '\([0-9]*\)\..*'`
LOCAL_DIR="lsws-${REL_VERSION}"
 
# http://www.litespeedtech.com/packages/3.0/lsws-3.3.12-ent-i386-linux.tar.gz
DOWNLOAD_URL="https://www.litespeedtech.com/packages/${MAJOR_VERSION}.0/lsws-${REL_VERSION}-ent${PLATFORM}.tar.gz"

if [ "x${STABLE_BUILD}" != "x" ]
then
    DOWNLOAD_URL="${DOWNLOAD_URL}.${STABLE_BUILD}"
fi

if [ ! -d "$WGET_TEMP" ] ; then
    mkdir -v -p "$WGET_TEMP"
    check_errs $? "error when creating downloading directory ... abort!"
    echo "  Download directory created"
fi

if [ -e "$WGET_TEMP/$LOCAL_DIR.tar.gz" ]; then
    /bin/rm -f "$WGET_TEMP/$LOCAL_DIR.tar.gz"
    echo "Package downloaded before, remove the old copy"
fi

echo "... Downloading ... $DOWNLOAD_URL"
wget -q --output-document=$WGET_TEMP/$LOCAL_DIR.tar.gz $DOWNLOAD_URL
check_errs $? "error when downloading ... abort!"

echo "Download finished successfully"


# Extracts the files
cd "$WGET_TEMP/"
echo "... Extracting... tar -zxf $WGET_TEMP/$LOCAL_DIR.tar.gz"

if [ -e "$WGET_TEMP/$LOCAL_DIR" ]; then
    /bin/rm -rf "$WGET_TEMP/$LOCAL_DIR"
fi

tar -zxf "$WGET_TEMP/$LOCAL_DIR.tar.gz"

check_errs $? "Could not extract $LOCAL_DIR.tar.gz"

#Moves files
echo "... Moving files..."
cp "$CUR_DIR/cPanelInstall.sh" "$WGET_TEMP/$LOCAL_DIR/"

if [ "$SERIAL" = "TRIAL" ] ; then   
    GetTrialKey
else
    echo "$SERIAL" > "$WGET_TEMP/$LOCAL_DIR/serial.no"
fi

echo ""

echo "Prepare Installing ..."

echo "
    LSWS_HOME=$LSWS_HOME
    PORT_OFFSET=$PORT_OFFSET
    PHP_SUEXEC=$PHP_SUEXEC
    ADMIN_LOGIN=$ADMIN_LOGIN
    "

cd "$WGET_TEMP/$LOCAL_DIR/"
sh ./cPanelInstall.sh $LSWS_HOME $PORT_OFFSET $PHP_SUEXEC "$ADMIN_LOGIN" "$ADMIN_PASS" "$ADMIN_EMAIL" 2>&1
check_errs $? "Failed to install, abort!"


echo "**COMPLETE**"

exit 0


