#!/bin/sh
# SCRIPT: install.sh
# PURPOSE: Install LS Web Cache Manager cPanel Plugin
# AUTHOR: LiteSpeed Technologies
#

PLUGIN_DIR='/usr/local/cpanel/base/frontend/paper_lantern/ls_web_cache_manager'
TEMP_CONF_FILE='/usr/local/cpanel/whostmgr/docroot/cgi/lsws/data/lswcm.conf'
PERL_MODULE_DIR='/usr/local/cpanel/Cpanel/API'
API_DIR='/usr/local/cpanel/bin/admin/Lsws'

pushd `dirname "$0"` > /dev/null

echo 'Installing LS Web Cache Manager...'
echo ""

# checks for existing plugin folder and	deletes	if exists
if [ -d $PLUGIN_DIR ]
then
    rm -rf $PLUGIN_DIR
fi

# Create the directory for the plugin
mkdir -p $PLUGIN_DIR

# Move all files to plugin directory
cp -r * ${PLUGIN_DIR}/

# Copy WHM temp cPanel plugin conf file to plugin directory
if [ -f ${TEMP_CONF_FILE} ] ; then
    cp -f ${TEMP_CONF_FILE} ${PLUGIN_DIR}/data/
fi

chmod -R 644 $PLUGIN_DIR
find ${PLUGIN_DIR}/ -type d -execdir chmod 755 {} +
chmod 700 ${PLUGIN_DIR}/*.sh
chmod -R 700 ${PLUGIN_DIR}/scripts
chmod 600 ${PLUGIN_DIR}/scripts/*.php

#Move interface file to paper_lantern directory.
mv -f ${PLUGIN_DIR}/ls_web_cache_manager.html.tt ${PLUGIN_DIR}/..

echo 'Installing needed Perl module and custom API calls...'
echo ""

cp -f ../lsws.pm ${PERL_MODULE_DIR}/

if [ ! -d $API_DIR ] ; then
    mkdir $API_DIR
fi

cp -f ../lswsAdminBin* ${API_DIR}/

chmod 700 ${API_DIR}/lswsAdminBin
chmod 644 ${API_DIR}/lswsAdminBin.conf
chmod 644 ${PERL_MODULE_DIR}/lsws.pm

# Install the plugin (which also places the png image in the proper location)
/usr/local/cpanel/scripts/install_plugin ${PLUGIN_DIR}/ls_web_cache_manager.tar.gz

# Check EC cert support setting
EC_SUPPORT_SETTING=$(grep -oP '(?<=GENERATE_EC_CERTS = )(\d)' "${PLUGIN_DIR}/data/lswcm.conf")

if [ "$EC_SUPPORT_SETTING" != "0" ] && [ "$EC_SUPPORT_SETTING" != "0" ] ; then
    echo "Enabling EC cert support..."
    echo ""

    "${PLUGIN_DIR}/scripts/cert_support_add.sh"
fi

echo 'Installation for  LS Web Cache Manager Completed!'
echo ""

popd > /dev/null
