#!/bin/sh
# SCRIPT: uninstall.sh
# PURPOSE: Uninstall LS Web Cache Manager cPanel Plugin
# AUTHOR: LiteSpeed Technologies
#

PLUGIN_DIR='/usr/local/cpanel/base/frontend/paper_lantern/ls_web_cache_manager'
PERL_MODULE='/usr/local/cpanel/Cpanel/API/lsws.pm'
API_DIR='/usr/local/cpanel/bin/admin/Lsws'

pushd `dirname "$0"` > /dev/null

echo 'Uninstalling LS Web Cache Manager...'
echo "";

if [ -e $PERL_MODULE ] ; then
    echo 'Removing custom LiteSpeed Perl module...'
    /bin/rm -f $PERL_MODULE
    echo "";
fi

if [ -d $API_DIR ] ; then
    echo 'Removing custom LiteSpeed API calls...'
    /bin/rm -rf $API_DIR
    echo "";
fi

echo 'Removing EC support hook...'
"${PLUGIN_DIR}/scripts/cert_support_remove.sh"
echo ""

#Remove cPanel plugin and files
if [ -e $CPANEL_PLUGIN_DIR ] ; then
    echo 'Removing LS Web Cache Manager cPanel Plugin...'
    /usr/local/cpanel/scripts/uninstall_plugin ${PLUGIN_DIR}/ls_web_cache_manager.tar.gz
    /bin/rm -f ${PLUGIN_DIR}/../ls_web_cache_manager.html.tt
    /bin/rm -rf $PLUGIN_DIR
    echo ""
fi

echo "Uninstallation finished."
echo ""

popd > /dev/null
