#!/bin/sh

CURDIR=`dirname "$0"`
cd $CURDIR
CURDIR=`pwd`
LSWSHOME=`dirname $CURDIR`
LSWSHOME=`dirname $LSWSHOME`

# Pass in 1 as the first param to force remount cage

fixCageFS()
{
    if [ -f "/etc/cagefs/cagefs.mp" ] ; then
    # cagefs installed first, need update mount point
        local FORCE_REMOUNT=$1;
        local REMOUNT=false
        local LSWS_DIR="${LSWSHOME}"

        cat /proc/mounts | grep -v 'deleted' | grep -q 'lsws'
        
        if [[ "$?" -eq 1 ]]; then
            REMOUNT=true

            grep -Eq "^$LSWS_DIR$" /etc/cagefs/cagefs.mp
            
            if [ $? = 1 ]; then
                sed -i -e '$a\' /etc/cagefs/cagefs.mp
                echo $LSWS_DIR >> /etc/cagefs/cagefs.mp

            fi
        fi

        grep -Eq "^/tmp/lshttpd$" /etc/cagefs/cagefs.mp
        if [ $? = 0 ]; then
            sed -i '\#/tmp/lshttpd#d' /etc/cagefs/cagefs.mp
            REMOUNT=true
        fi

        if [ $FORCE_REMOUNT -eq 1 ] || $REMOUNT; then
            cagefsctl --remount-all
        fi

    fi
}

fixCageFS ${1:-0}
